/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.deployment;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.configuration.XldProductConfiguration;
import com.xebialabs.deployit.deployment.planner.MultiDeltaSpecification;
import com.xebialabs.deployit.deployment.planner.PhasedPlan;
import com.xebialabs.deployit.deployment.planner.PipedPlanner;
import com.xebialabs.deployit.deployment.planner.Plan;
import com.xebialabs.deployit.deployment.planner.Planner;
import com.xebialabs.deployit.deployment.planner.RepositoryUpdateStep;
import com.xebialabs.deployit.deployment.planner.StepPlan;
import com.xebialabs.deployit.deployment.rules.PlanCreationContext;
import com.xebialabs.deployit.deployment.rules.PlanCreationContextFactory;
import com.xebialabs.deployit.deployment.rules.RuleBasedPlannerFactory;
import com.xebialabs.deployit.deployment.stager.DeploymentStager;
import com.xebialabs.deployit.inspection.Inspector;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.test.deployment.PlanUtils;
import com.xebialabs.deployit.test.repository.InMemoryRepository;
import com.xebialabs.deployit.test.support.TestExecutionContext;
import com.xebialabs.deployit.test.support.TestInspectionContext;
import com.xebialabs.xldeploy.packager.io.StreamerFactory;
import com.xebialabs.xldeploy.packager.placeholders.DerivedArtifactEnricher;
import com.xebialabs.xlplatform.config.ConfigurationHolder;
import com.xebialabs.xlplatform.config.ProductConfiguration;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployitTester {
    private final Planner planner;
    private final PlanCreationContextFactory planCreationContextFactory;
    private RuleBasedPlannerFactory factory;
    private final InMemoryRepository repository;
    private final ProductConfiguration productConfiguration = new XldProductConfiguration();
    private Function<String, Object> idToCi = new Function<String, Object>(){

        public Object apply(String input) {
            return DeployitTester.this.repository.read(input);
        }
    };
    private static final Splitter STRING_TO_COLLECTION_SPLITTER = Splitter.on((char)',').omitEmptyStrings();
    private static final Logger planLogger = LoggerFactory.getLogger(StepPlan.class);

    public DeployitTester() {
        this.repository = new InMemoryRepository();
        this.repository.clear();
        new ConfigurationHolder(this.productConfiguration).init();
        this.factory = new RuleBasedPlannerFactory();
        this.planCreationContextFactory = this.factory.planerCreationContextFactory();
        this.planner = this.factory.plannerWithoutStaging();
    }

    public DeployitTester(Planner planner) {
        this.repository = new InMemoryRepository();
        this.repository.clear();
        new ConfigurationHolder(this.productConfiguration).init();
        this.factory = new RuleBasedPlannerFactory();
        this.planCreationContextFactory = this.factory.planerCreationContextFactory();
        this.planner = planner;
    }

    public void shutdown() {
        if (this.factory != null) {
            this.factory.shutdownTheSystem();
        }
    }

    public List<Step> resolvePlan(DeltaSpecification spec) {
        return Lists.transform(PlanUtils.flattenPlan((Plan)this.resolve(spec)), (Function)StepPlan.stepsWithDeltaToSteps);
    }

    public List<Step> resolvePlanWithStaging(DeltaSpecification spec) {
        MultiDeltaSpecification multiDeltaSpecification = new MultiDeltaSpecification(spec);
        PlanCreationContext planCreationContext = this.planCreationContextFactory.createPlanCreationContext((Repository)this.repository);
        PhasedPlan phasedPlan = this.planner.plan(multiDeltaSpecification, planCreationContext);
        PhasedPlan plan = new DeploymentStager().transform(new PipedPlanner.TransformerContext(phasedPlan, multiDeltaSpecification, planCreationContext));
        planLogger.info("Generated plan for {}:\n{}\n", (Object)DeployitTester.firstCallerOnStack("com.xebialabs"), (Object)plan.writePlan((Writer)new StringWriter()));
        return Lists.transform(PlanUtils.flattenPlan((Plan)plan), (Function)StepPlan.stepsWithDeltaToSteps);
    }

    public static List<Step> resolvePlan(Plan plan) {
        return Lists.transform(PlanUtils.flattenPlan(plan), (Function)StepPlan.stepsWithDeltaToSteps);
    }

    public static List<StepPlan.Checkpoint> resolveCheckpoints(Plan plan) {
        return PlanUtils.resolveCheckpoints(plan);
    }

    public PhasedPlan resolve(DeltaSpecification spec) {
        PhasedPlan plan = this.planner.plan(new MultiDeltaSpecification(spec), this.planCreationContextFactory.createPlanCreationContext((Repository)this.repository));
        planLogger.info("Generated plan for {}:\n{}\n", (Object)DeployitTester.firstCallerOnStack("com.xebialabs"), (Object)plan.writePlan((Writer)new StringWriter()));
        return plan;
    }

    private static String firstCallerOnStack(String packagePrefix) {
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        for (int i = stackTrace.length - 1; i >= 0; --i) {
            StackTraceElement frame = stackTrace[i];
            if (!frame.getClassName().startsWith(packagePrefix)) continue;
            return frame.getMethodName();
        }
        return "<unknown>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigurationItem> runInspectionTask(ConfigurationItem item) {
        TestExecutionContext executionContext = new TestExecutionContext((Repository)this.repository);
        try {
            List<ConfigurationItem> list = this.runInspectionTask(item, executionContext);
            return list;
        }
        finally {
            executionContext.destroy();
        }
    }

    public List<ConfigurationItem> runInspectionTask(ConfigurationItem item, TestExecutionContext executionContext) {
        TestInspectionContext inspectionContext = executionContext.getInspectionContext();
        Inspector.inspect((ConfigurationItem)item, (InspectionContext)inspectionContext);
        StepExitCode result = DeployitTester.executePlan(inspectionContext.getSteps(), executionContext);
        if (result == StepExitCode.FAIL) {
            throw new DeployitTesterException("Inspection of " + item + " failed.", new Object[0]);
        }
        return new ArrayList<ConfigurationItem>(inspectionContext.getInspected().values());
    }

    public Deployed generateDeployed(Deployable d, Container c, Type deployedType) {
        return this.generateDeployed(d, c, deployedType, null);
    }

    public Deployed generateDeployed(Deployable d, Container c, Type deployedType, Map<String, String> placeholders) {
        Descriptor deployed = DescriptorRegistry.getDescriptor((Type)deployedType);
        Deployed configurationItem = (Deployed)deployed.newInstance(c.getId() + "/" + DeployitTester.substringAfterLastSlash(d.getId()));
        configurationItem.setDeployable(d);
        configurationItem.setContainer(c);
        Descriptor deployableDescriptor = DescriptorRegistry.getDescriptor((Type)d.getType());
        for (PropertyDescriptor propertyDescriptor : deployed.getPropertyDescriptors()) {
            String name = propertyDescriptor.getName();
            PropertyDescriptor deployablePropertyDescriptor = deployableDescriptor.getPropertyDescriptor(name);
            if (deployablePropertyDescriptor == null) continue;
            if (propertyDescriptor.getName().equals("placeholders")) {
                propertyDescriptor.set((ConfigurationItem)configurationItem, (Object)Maps.newHashMap());
                continue;
            }
            propertyDescriptor.set((ConfigurationItem)configurationItem, this.convertCiValuesIfNeeded(deployablePropertyDescriptor.get((ConfigurationItem)d), propertyDescriptor, deployablePropertyDescriptor));
        }
        if (configurationItem instanceof DerivedArtifact) {
            DerivedArtifact da = (DerivedArtifact)configurationItem;
            if (placeholders != null) {
                da.setPlaceholders(placeholders);
            }
            new DerivedArtifactEnricher(da, StreamerFactory.defaultMappings()).enrichArtifact();
        }
        return configurationItem;
    }

    private Object convertCiValuesIfNeeded(Object o, PropertyDescriptor deployedPropertyDescriptor, PropertyDescriptor deployablePropertyDescriptor) {
        if (o == null) {
            return null;
        }
        if (deployablePropertyDescriptor.getKind() == PropertyKind.STRING && deployedPropertyDescriptor.getKind() == PropertyKind.CI) {
            return this.repository.read((String)o);
        }
        if (deployablePropertyDescriptor.getKind() == PropertyKind.LIST_OF_STRING && deployedPropertyDescriptor.getKind() == PropertyKind.LIST_OF_CI) {
            return Lists.newArrayList((Iterable)Lists.transform((List)((List)o), this.idToCi));
        }
        if (deployablePropertyDescriptor.getKind() == PropertyKind.STRING && deployedPropertyDescriptor.getKind() == PropertyKind.LIST_OF_CI) {
            return Lists.newArrayList((Iterable)Iterables.transform((Iterable)STRING_TO_COLLECTION_SPLITTER.split((CharSequence)((String)o)), this.idToCi));
        }
        if (deployablePropertyDescriptor.getKind() == PropertyKind.SET_OF_STRING && deployedPropertyDescriptor.getKind() == PropertyKind.SET_OF_CI) {
            return Sets.newHashSet((Iterable)Collections2.transform((Collection)((Set)o), this.idToCi));
        }
        if (deployablePropertyDescriptor.getKind() == PropertyKind.STRING && deployedPropertyDescriptor.getKind() == PropertyKind.SET_OF_CI) {
            return Lists.newArrayList((Iterable)Iterables.transform((Iterable)STRING_TO_COLLECTION_SPLITTER.split((CharSequence)((String)o)), this.idToCi));
        }
        return o;
    }

    private static String substringAfterLastSlash(String id) {
        int i = id.lastIndexOf(47);
        if (i > -1) {
            return id.substring(i + 1);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepExitCode executePlan(List<Step> plan) {
        TestExecutionContext ctx = new TestExecutionContext(this.getClass(), (Repository)this.repository);
        try {
            StepExitCode stepExitCode = DeployitTester.executePlan(plan, ctx);
            return stepExitCode;
        }
        finally {
            ctx.destroy();
        }
    }

    public static StepExitCode executePlan(List<Step> steps, ExecutionContext context) {
        StepExitCode result = StepExitCode.PAUSE;
        try {
            Step step;
            for (int i = 0; i < steps.size() && ((step = steps.get(i)) instanceof RepositoryUpdateStep || (result = step.execute(context)) != StepExitCode.FAIL); ++i) {
            }
            return result;
        }
        catch (Exception e) {
            throw new DeployitTesterException(e);
        }
    }

    public Repository repository() {
        return this.repository;
    }

    public static class DeployitTesterException
    extends RuntimeException {
        DeployitTesterException(String message, Object ... params) {
            super(String.format(message, params));
        }

        DeployitTesterException(Exception e) {
            super(e);
        }
    }
}

