/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.inspection.Inspector;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.List;
import java.util.Map;

public class TestInspectionContext
implements InspectionContext {
    private Map<String, ConfigurationItem> discovered = Maps.newLinkedHashMap();
    private Map<String, ConfigurationItem> inspected = Maps.newLinkedHashMap();
    private List<Step> steps = Lists.newArrayList();

    public void discovered(ConfigurationItem item) {
        Preconditions.checkArgument((item.getId() != null ? 1 : 0) != 0, (Object)"Discovered configuration item must have an id set.");
        this.discovered.put(item.getId(), item);
        Inspector.inspect((ConfigurationItem)item, (InspectionContext)this);
    }

    public Map<String, ConfigurationItem> getDiscovered() {
        return this.discovered;
    }

    public void inspected(ConfigurationItem item) {
        this.discovered.remove(item.getId());
        this.inspected.put(item.getId(), item);
    }

    public Map<String, ConfigurationItem> getInspected() {
        return this.inspected;
    }

    public void addStep(Step step) {
        this.steps.add(step);
    }

    public List<Step> getSteps() {
        return this.steps;
    }
}

