/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.itest.cloudhost;

import com.google.common.base.Function;
import com.google.common.util.concurrent.ListenableFuture;
import com.xebialabs.deployit.booter.local.utils.Closeables;
import com.xebialabs.deployit.itest.cloudhost.CloudHostFutureTransformer;
import com.xebialabs.overcast.host.CloudHost;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitForOpenPortTransformer
implements CloudHostFutureTransformer {
    private static final Logger logger = LoggerFactory.getLogger(WaitForOpenPortTransformer.class);
    private final int port;
    private final int timeoutSeconds;

    public WaitForOpenPortTransformer(int port, int timeoutSeconds) {
        this.port = port;
        this.timeoutSeconds = timeoutSeconds;
    }

    @Override
    public Function<CloudHost, CloudHost> transform(ListenableFuture<CloudHost> host) {
        return new Function<CloudHost, CloudHost>(){

            public CloudHost apply(CloudHost host) {
                logger.info("Waiting for port {}:{}", (Object)host.getHostName(), (Object)WaitForOpenPortTransformer.this.port);
                WaitForOpenPortTransformer.waitForPort(host.getHostName(), WaitForOpenPortTransformer.this.port, WaitForOpenPortTransformer.this.timeoutSeconds);
                return host;
            }
        };
    }

    public static void waitForPort(String hostOrIp, int port, int timeoutSeconds) {
        for (int i = 0; i < timeoutSeconds; ++i) {
            if (WaitForOpenPortTransformer.isPortOpen(hostOrIp, port)) {
                logger.info("Port {}:{} is open.", (Object)hostOrIp, (Object)port);
                return;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                logger.debug("Interrupted stopping waitForPort {}:{}", (Object)hostOrIp, (Object)port);
                break;
            }
        }
        throw new RuntimeException(String.format("Timeout expired waiting for port %s:%d", hostOrIp, port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortOpen(String hostOrIp, int port) {
        int timeout = 5000;
        Socket socket = new Socket();
        try {
            InetSocketAddress endPoint = new InetSocketAddress(InetAddress.getByName(hostOrIp), port);
            if (endPoint.isUnresolved()) {
                boolean bl = false;
                return bl;
            }
            socket.connect(endPoint, 5000);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.debug("Exception testing connection to {}:{}: {}", new Object[]{hostOrIp, port, e.getMessage()});
        }
        finally {
            Closeables.closeQuietly((Closeable)socket);
        }
        return false;
    }
}

