package com.xebialabs.deployit.test.support;

import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.inspection.Inspector;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Maps.newLinkedHashMap;

public class TestInspectionContext implements InspectionContext {

    private Map<String, ConfigurationItem> discovered = newLinkedHashMap();
    private Map<String, ConfigurationItem> inspected = newLinkedHashMap();
    private List<Step> steps = newArrayList();

    @Override
    public void discovered(ConfigurationItem item) {
        checkArgument(item.getId() != null, "Discovered configuration item must have an id set.");
        discovered.put(item.getId(), item);
        Inspector.inspect(item, this);
    }

    @Override
    public Map<String, ConfigurationItem> getDiscovered() {
        return discovered;
    }

    @Override
    public void inspected(ConfigurationItem item) {
        discovered.remove(item.getId());
        inspected.put(item.getId(), item);
    }

    @Override
    public Map<String, ConfigurationItem> getInspected() {
        return inspected;
    }

    @Override
    public void addStep(Step step) {
        steps.add(step);
    }

    public List<Step> getSteps() {
        return steps;
    }
}