package com.xebialabs.deployit.test.deployment;

import java.util.List;

import com.xebialabs.deployit.deployment.planner.CompositePlan;
import com.xebialabs.deployit.deployment.planner.StepPlan;
import com.xebialabs.deployit.deployment.planner.Plan;
import com.xebialabs.deployit.deployment.planner.SerialPlan;

import static com.google.common.collect.Lists.newArrayList;

public class PlanUtils {

    public static List<StepPlan.StepWithPlanningInfo> flattenPlan(Plan plan) {
        List<StepPlan.StepWithPlanningInfo> stepsWithDelta = newArrayList();

        if (plan instanceof CompositePlan) {
            for (Plan subPlan : ((CompositePlan) plan).getSubPlans()) {
                if (subPlan instanceof StepPlan) {
                    stepsWithDelta.addAll(((StepPlan) subPlan).getStepsWithPlanningInfo());
                } else if (subPlan instanceof CompositePlan) {
                    stepsWithDelta.addAll(flattenPlan(subPlan));
                } else {
                    throw new RuntimeException("Can not flatten " + subPlan.getClass().getSimpleName());
                }
            }
        } else {
            stepsWithDelta.addAll(((StepPlan) plan).getStepsWithPlanningInfo());
        }
        return stepsWithDelta;
    }

    public static List<StepPlan.Checkpoint> resolveCheckpoints(Plan plan) {
        List<StepPlan.Checkpoint> checkpoints = newArrayList();
        if (plan instanceof SerialPlan) {
            for (Plan subPlan : ((SerialPlan) plan).getSubPlans()) {
                checkpoints.addAll(resolveCheckpoints(subPlan));
            }
        } else if (plan instanceof StepPlan) {
            checkpoints.addAll(((StepPlan) plan).getCheckpoints());
        } else {
            throw new RuntimeException("Can not flatten " + plan.getClass().getSimpleName());
        }
        return checkpoints;
    }
}
