/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.deployment;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.deployment.planner.CompositePlan;
import com.xebialabs.deployit.deployment.planner.Plan;
import com.xebialabs.deployit.deployment.planner.SerialPlan;
import com.xebialabs.deployit.deployment.planner.StepPlan;
import java.util.ArrayList;
import java.util.List;

public class PlanUtils {
    public static List<StepPlan.StepWithDelta> flattenPlan(Plan plan) {
        ArrayList stepsWithDelta = Lists.newArrayList();
        if (plan instanceof CompositePlan) {
            for (Plan subPlan : ((CompositePlan)plan).getSubPlans()) {
                if (subPlan instanceof StepPlan) {
                    stepsWithDelta.addAll(((StepPlan)subPlan).getStepsWithDelta());
                    continue;
                }
                if (subPlan instanceof CompositePlan) {
                    stepsWithDelta.addAll(PlanUtils.flattenPlan(subPlan));
                    continue;
                }
                throw new RuntimeException("Can not flatten " + subPlan.getClass().getSimpleName());
            }
        } else {
            stepsWithDelta.addAll(((StepPlan)plan).getStepsWithDelta());
        }
        return stepsWithDelta;
    }

    public static List<StepPlan.Checkpoint> resolveCheckpoints(Plan plan) {
        ArrayList checkpoints = Lists.newArrayList();
        if (plan instanceof SerialPlan) {
            for (Plan subPlan : ((SerialPlan)plan).getSubPlans()) {
                checkpoints.addAll(PlanUtils.resolveCheckpoints(subPlan));
            }
        } else if (plan instanceof StepPlan) {
            checkpoints.addAll(((StepPlan)plan).getCheckpoints());
        } else {
            throw new RuntimeException("Can not flatten " + plan.getClass().getSimpleName());
        }
        return checkpoints;
    }
}

