/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.itest;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.deployment.planner.DeltaSpecificationBuilder;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.test.deployment.DeltaSpecifications;
import com.xebialabs.deployit.test.deployment.DeployitTester;
import com.xebialabs.deployit.test.support.TestExecutionContext;
import com.xebialabs.platform.test.TestUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class ItestWizard {
    private DeployitTester tester;

    public ItestWizard(DeployitTester tester) {
        this.tester = tester;
    }

    public Deployed<?, ?> deployed(Deployable deployable, Container container, String type, Map<String, String> properties) {
        Deployed deployed = this.tester.generateDeployed(deployable, container, Type.valueOf((String)type));
        deployed.setId(deployable.getId());
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            deployed.setProperty(entry.getKey(), (Object)entry.getValue());
        }
        return deployed;
    }

    public Deployed<?, ?> deployed(Deployable deployable, Container container, String type) {
        return this.deployed(deployable, container, type, Collections.EMPTY_MAP);
    }

    public static DeployedApplication newDeployedApplication(String name, String version, Deployed ... deployeds) {
        List deployables = Lists.transform(Arrays.asList(deployeds), (Function)new Function<Deployed, Deployable>(){

            public Deployable apply(Deployed d) {
                return d.getDeployable();
            }
        });
        DeploymentPackage pkg = ItestWizard.newDeploymentPackage(name, version, deployables.toArray(new Deployable[0]));
        Environment env = TestUtils.createEnvironment((Container[])new Container[0]);
        DeployedApplication deployedApp = (DeployedApplication)TestUtils.newInstance((String)"udm.DeployedApplication");
        deployedApp.setVersion((Version)pkg);
        deployedApp.setEnvironment(env);
        deployedApp.setId(TestUtils.id((String[])new String[]{env.getId(), name}));
        deployedApp.addDeployeds(deployeds);
        return deployedApp;
    }

    public static DeployedApplication newDeployedApplication(String name, String version, Deployable ... deployables) {
        DeploymentPackage pkg = ItestWizard.newDeploymentPackage(name, version, deployables);
        Environment env = TestUtils.createEnvironment((Container[])new Container[0]);
        DeployedApplication deployedApp = (DeployedApplication)TestUtils.newInstance((String)"udm.DeployedApplication");
        deployedApp.setVersion((Version)pkg);
        deployedApp.setEnvironment(env);
        deployedApp.setId(TestUtils.id((String[])new String[]{env.getId(), name}));
        return deployedApp;
    }

    public static DeploymentPackage newDeploymentPackage(String name, String version, Deployable ... deployables) {
        Application app = (Application)TestUtils.newInstance((String)"udm.Application");
        app.setId(TestUtils.id((String[])new String[]{"Application", name}));
        DeploymentPackage pkg = (DeploymentPackage)TestUtils.newInstance((String)"udm.DeploymentPackage");
        pkg.setId(TestUtils.id((String[])new String[]{app.getId(), version}));
        pkg.setApplication(app);
        for (Deployable d : deployables) {
            d.setId(TestUtils.id((String[])new String[]{app.getId(), d.getId()}));
            pkg.addDeployable(d);
        }
        return pkg;
    }

    public void assertInitial(DeployedApplication app) {
        DeltaSpecificationBuilder builder = new DeltaSpecificationBuilder().initial(DeltaSpecifications.createDeployedApplication(app.getVersion(), app.getEnvironment()));
        for (Deployed d : app.getDeployeds()) {
            builder.create(d);
        }
        this.assertPlan(builder.build());
    }

    public void assertUpgrade(Version newVersion, DeployedApplication app, Deployed prevDeployed, Deployed deployed) {
        DeltaSpecification spec = new DeltaSpecificationBuilder().upgrade(DeltaSpecifications.createDeployedApplication(newVersion, app.getEnvironment())).modify(prevDeployed, deployed).build();
        this.assertPlan(spec);
    }

    public void assertUpgrade(DeployedApplication oldVersion, DeployedApplication newVersion) {
        ArrayList deployeds1 = Lists.newArrayList((Iterable)oldVersion.getDeployeds());
        Version newVersion1 = newVersion.getVersion();
        ArrayList deployeds2 = Lists.newArrayList((Iterable)newVersion.getDeployeds());
        Deployable[] deployables = newVersion1.getDeployables().toArray(new Deployable[0]);
        DeployedApplication newDeployedApplication = ItestWizard.newDeployedApplication(newVersion1.getApplication().getName(), newVersion1.getVersion(), deployables);
        DeltaSpecificationBuilder builder = new DeltaSpecificationBuilder().upgrade(DeltaSpecifications.createDeployedApplication(newVersion1, newDeployedApplication.getEnvironment()));
        Assert.assertThat((String)"This method can assert only upgrades when amound of deployeds is not changed", (Object)deployeds1.size(), (Matcher)CoreMatchers.is((Object)deployeds2.size()));
        for (int i = 0; i < deployeds1.size(); ++i) {
            builder.modify((Deployed)deployeds1.get(i), (Deployed)deployeds2.get(i));
        }
        this.assertPlan(builder.build());
    }

    public void assertUndeploy(DeployedApplication app) {
        DeltaSpecificationBuilder builder = new DeltaSpecificationBuilder().undeploy(app);
        for (Deployed deployed : app.getDeployeds()) {
            builder.destroy(deployed);
        }
        this.assertPlan(builder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertPlan(DeltaSpecification spec) {
        List<Step> steps = this.tester.resolvePlan(spec);
        TestExecutionContext ctx = new TestExecutionContext(ItestWizard.class);
        try {
            Assert.assertThat((Object)DeployitTester.executePlan(steps, ctx), (Matcher)CoreMatchers.is((Object)StepExitCode.SUCCESS));
        }
        finally {
            ctx.destroy();
        }
    }
}

