/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.deployment.planner.DeltaSpecificationBuilder;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.test.deployment.DeployitTester;
import com.xebialabs.deployit.test.support.CloudHostRegistry;
import com.xebialabs.deployit.test.support.DeployedItestChangeSet;
import com.xebialabs.deployit.test.support.ItestTopology;
import com.xebialabs.deployit.test.support.TestExecutionContext;
import com.xebialabs.deployit.test.support.TestUtils;
import com.xebialabs.overcast.CloudHost;
import com.xebialabs.overcast.CloudHostFactory;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jdom2.JDOMException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class DeployedItestBase {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private static final String DEPLOYED_ITEST_DIR = "deployed-test-scripts";
    private String description;
    private File deployedChangeSetXmlFile;
    protected ItestTopology topology;
    protected Container container;
    private static DeployitTester tester;
    protected DeployedItestChangeSet deployedChangeSet;
    private static TestExecutionContext context;

    public DeployedItestBase(String description, File deployedChangeSetXmlFile, ItestTopology topology, Container container) {
        this.description = description;
        this.deployedChangeSetXmlFile = deployedChangeSetXmlFile;
        this.topology = topology;
        this.container = container;
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> getTargets() throws Exception {
        ArrayList<Object[]> constructorArgsList = new ArrayList<Object[]>();
        Map<String, ItestTopology> topologies = ItestTopology.load();
        for (File deployedItestFile : DeployedItestBase.getDeployedItestFiles()) {
            String desc = "Test " + deployedItestFile.getName() + " on ";
            for (ItestTopology topology : topologies.values()) {
                if (!ItestTopology.isItestEnabled(topology.getId(), topology.isEnabledByDefault())) continue;
                for (Container container : topology.getTargets()) {
                    constructorArgsList.add(new Object[]{desc + container, deployedItestFile, topology, container});
                }
            }
        }
        return constructorArgsList;
    }

    @Before
    public void takeCareOfVagrantImages() {
        CloudHost cloudHost = CloudHostFactory.getCloudHost((String)this.topology.getId());
        if (cloudHost != null) {
            CloudHostRegistry.getInstance().makeSureIsUp(cloudHost);
            CloudHostRegistry.getInstance().makeSureAllDownInTheEnd();
        }
    }

    @Before
    public void prepareDeployedChangeSet() throws JDOMException, IOException {
        this.deployedChangeSet = DeployedItestChangeSet.loadChangeSet(this.deployedChangeSetXmlFile, this.container, this.topology, this.folder);
    }

    @After
    public void clearInspectionContext() {
        context.clearInspectionContext();
    }

    @BeforeClass
    public static void setup() {
        tester = new DeployitTester();
        context = new TestExecutionContext(DeployedItestBase.class, tester.repository());
    }

    @AfterClass
    public static void tearDown() {
        context.destroy();
    }

    private static Iterable<File> getDeployedItestFiles() throws URISyntaxException, IOException {
        File deployedItestDir = DeployedItestBase.getDeployedItestDir();
        final List<String> enabledItests = DeployedItestBase.getEnabledItests();
        return Iterables.filter(Arrays.asList(deployedItestDir.listFiles()), (Predicate)new Predicate<File>(){

            public boolean apply(File input) {
                String name = input.getName();
                return name.endsWith(".xml") && (enabledItests.isEmpty() || enabledItests.contains(name));
            }
        });
    }

    private static File getDeployedItestDir() throws URISyntaxException {
        URL deployedItestDirUrl = Thread.currentThread().getContextClassLoader().getResource(DEPLOYED_ITEST_DIR);
        Preconditions.checkNotNull((Object)deployedItestDirUrl);
        return new File(deployedItestDirUrl.toURI());
    }

    private static List<String> getEnabledItests() throws URISyntaxException, IOException {
        File deployedItestDir = DeployedItestBase.getDeployedItestDir();
        File enabledItestsFile = new File(deployedItestDir, "enabled-itests");
        ArrayList enabledItests = Lists.newArrayList();
        if (enabledItestsFile.exists()) {
            List tests = Files.readLines((File)enabledItestsFile, (Charset)Charset.defaultCharset());
            enabledItests.addAll(tests);
        }
        return enabledItests;
    }

    @Test
    public void shouldCreateAndDestroyDeployed() throws Exception {
        Assume.assumeTrue((boolean)this.deployedChangeSet.hasDeployedsToCreate());
        List<Deployed> deployedsToCreate = this.deployedChangeSet.getDeployedsToCreate();
        if (this.shouldCheckDeployedsDoNotExistBeforeCreating()) {
            this.assertDeployedsDoNotExist(deployedsToCreate);
            context.clearInspectionContext();
        }
        if (this.shouldCreateDeployed()) {
            this.createDeployeds(deployedsToCreate);
            context.clearInspectionContext();
        }
        if (this.shouldCheckDeployedsCreatedCorrectly()) {
            this.assertDeployedsWereCreatedCorrectly(deployedsToCreate);
            context.clearInspectionContext();
        }
        if (this.deployedChangeSet.hasDeployedsToModify() && this.shouldModifyDeployeds()) {
            this.modifyDeployeds(this.deployedChangeSet);
            context.clearInspectionContext();
            if (this.shouldCheckDeployedsModifiedCorrectly()) {
                this.assertDeployedsWereCreatedCorrectly(this.deployedChangeSet.getDeployedsToModify());
                context.clearInspectionContext();
            }
        }
        if (this.shouldDestroyDeployeds()) {
            this.destroyDeployeds(deployedsToCreate);
            context.clearInspectionContext();
        }
        if (this.shouldCheckDeployedsDoNotExistAfterDelete()) {
            this.assertDeployedsDoNotExist(deployedsToCreate);
            context.clearInspectionContext();
        }
    }

    protected void createDeployeds(List<Deployed> deployeds) {
        DeltaSpecificationBuilder builder = new DeltaSpecificationBuilder().initial(TestUtils.createDeployedApplication(TestUtils.createDeploymentPackage("1.0", new Deployable[0]), TestUtils.createEnvironment(this.container)));
        for (Deployed d : deployeds) {
            List validationErrors = DescriptorRegistry.getDescriptor((Type)d.getType()).validate((ConfigurationItem)d);
            if (validationErrors.isEmpty()) {
                builder.create(d);
                continue;
            }
            Assert.fail((String)("Deployed has validation errors: " + validationErrors));
        }
        DeltaSpecification spec = builder.build();
        List<Step> resolvedPlan = tester.resolvePlan(spec);
        StepExitCode result = tester.executePlan(resolvedPlan, context);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)StepExitCode.SUCCESS));
    }

    protected void modifyDeployeds(DeployedItestChangeSet deployedChangeSet) {
        DeltaSpecificationBuilder builder = new DeltaSpecificationBuilder().upgrade(TestUtils.createDeployedApplication(TestUtils.createDeploymentPackage("1.0", new Deployable[0]), TestUtils.createEnvironment(this.container)));
        for (Deployed d : deployedChangeSet.getDeployedsToModify()) {
            List validationErrors = DescriptorRegistry.getDescriptor((Type)d.getType()).validate((ConfigurationItem)d);
            if (validationErrors.isEmpty()) {
                builder.modify(deployedChangeSet.getDeployedToCreate(d.getId()), d);
                continue;
            }
            Assert.fail((String)("Deployed has validation errors: " + validationErrors));
        }
        DeltaSpecification spec = builder.build();
        List<Step> resolvedPlan = tester.resolvePlan(spec);
        StepExitCode result = tester.executePlan(resolvedPlan, context);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)StepExitCode.SUCCESS));
    }

    protected void destroyDeployeds(List<Deployed> deployeds) {
        DeltaSpecificationBuilder builder = new DeltaSpecificationBuilder().undeploy(TestUtils.createDeployedApplication(TestUtils.createDeploymentPackage("1.0", new Deployable[0]), TestUtils.createEnvironment(this.container)));
        for (Deployed d : deployeds) {
            builder.destroy(d);
        }
        DeltaSpecification spec = builder.build();
        List<Step> resolvedPlan = tester.resolvePlan(spec);
        StepExitCode result = tester.executePlan(resolvedPlan, context);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)StepExitCode.SUCCESS));
    }

    protected void assertDeployedsDoNotExist(List<Deployed> deployeds) {
        block3: {
            try {
                List<Deployed> actualDeployeds = this.inspectDeployeds(deployeds);
                if (actualDeployeds.size() > 0) {
                    Assert.fail((String)String.format("Expected deployeds [%s] to not exist", Joiner.on((String)",").join(actualDeployeds)));
                }
            }
            catch (RuntimeException e) {
                if (e.getMessage().contains("Step failed:") || e.getMessage().contains("CliScriptException")) break block3;
                throw e;
            }
        }
    }

    protected void assertDeployedsWereCreatedCorrectly(List<Deployed> expectedDeployeds) {
        List<Deployed> actualDeployeds = this.inspectDeployeds(expectedDeployeds);
        if (actualDeployeds.size() != expectedDeployeds.size()) {
            Assert.fail((String)String.format("Expected deployeds [%s] to exist, but only found [%s]", Joiner.on((String)",").join(expectedDeployeds), Joiner.on((String)",").join(actualDeployeds)));
        }
        for (Deployed expected : expectedDeployeds) {
            int i = actualDeployeds.indexOf(expected);
            Preconditions.checkArgument((i != -1 ? 1 : 0) != 0, (String)"Cannot find [%s] in list of existing deployeds", (Object[])new Object[]{expected});
            Deployed actual = actualDeployeds.get(i);
            this.assertDeployedWasCreatedCorrectly(expected, actual);
        }
    }

    protected void assertDeployedWasCreatedCorrectly(Deployed expectedDeployed, Deployed actualDeployed) {
        Descriptor dd = DescriptorRegistry.getDescriptor((Type)expectedDeployed.getType());
        block5: for (PropertyDescriptor pd : dd.getPropertyDescriptors()) {
            if (pd.isHidden() || pd.isPassword() || pd.getKind() == PropertyKind.LIST_OF_CI) continue;
            switch (pd.getKind()) {
                case MAP_STRING_STRING: {
                    Map expectedMap = (Map)pd.get((ConfigurationItem)expectedDeployed);
                    Map inspectedMap = (Map)pd.get((ConfigurationItem)actualDeployed);
                    if (expectedMap == null) continue block5;
                    Assert.assertThat((Object)inspectedMap.size(), (Matcher)CoreMatchers.equalTo((Object)expectedMap.size()));
                    for (Map.Entry eachEntry : inspectedMap.entrySet()) {
                        Assert.assertThat(inspectedMap.get(eachEntry.getKey()), (Matcher)CoreMatchers.equalTo(expectedMap.get(eachEntry.getKey())));
                    }
                    continue block5;
                }
                case SET_OF_STRING: {
                    Integer diffInStringSets = Sets.symmetricDifference((Set)((Set)pd.get((ConfigurationItem)expectedDeployed)), (Set)((Set)pd.get((ConfigurationItem)actualDeployed))).size();
                    Assert.assertThat((String)("Expected " + pd.get((ConfigurationItem)expectedDeployed) + " but was " + pd.get((ConfigurationItem)actualDeployed)), (Object)diffInStringSets, (Matcher)CoreMatchers.equalTo((Object)0));
                    break;
                }
                case SET_OF_CI: {
                    HashSet set1 = Sets.newHashSet((Iterable)((Set)pd.get((ConfigurationItem)expectedDeployed)));
                    HashSet set2 = Sets.newHashSet((Iterable)((Set)pd.get((ConfigurationItem)actualDeployed)));
                    Integer diffInCiSets = Sets.symmetricDifference((Set)set1, (Set)set2).size();
                    Assert.assertThat((String)("Expected " + pd.get((ConfigurationItem)expectedDeployed) + " but was " + pd.get((ConfigurationItem)actualDeployed)), (Object)diffInCiSets, (Matcher)CoreMatchers.equalTo((Object)0));
                    break;
                }
                default: {
                    Object inspectedValue = pd.get((ConfigurationItem)actualDeployed);
                    Object expectedValue = pd.get((ConfigurationItem)expectedDeployed);
                    if (expectedValue == null) continue block5;
                    Assert.assertThat((String)("Expected " + pd.get((ConfigurationItem)expectedDeployed) + " but was " + pd.get((ConfigurationItem)actualDeployed)), (Object)inspectedValue, (Matcher)CoreMatchers.equalTo((Object)expectedValue));
                }
            }
        }
    }

    protected List<Deployed> inspectDeployeds(final List<Deployed> deployeds) {
        ArrayList typesToDiscover = Lists.newArrayList();
        typesToDiscover.addAll(this.deployedChangeSet.getAdditionalTypesToDiscover());
        typesToDiscover.addAll(Lists.transform(deployeds, (Function)new Function<Deployed, Type>(){

            public Type apply(Deployed input) {
                return input.getType();
            }
        }));
        List<Object> discovered = Lists.newArrayList();
        ConfigurationItem ciToPerformInspectionOn = this.getCiToPerformInspectionOn(typesToDiscover);
        if (ciToPerformInspectionOn != null) {
            discovered = tester.runInspectionTask(ciToPerformInspectionOn, context);
        } else {
            if (!this.deployedChangeSet.getAdditionalTypesToDiscover().isEmpty()) {
                throw new UnsupportedOperationException("The discovery of additional typess is not supported using old style discovery.");
            }
            for (Deployed deployed : this.deployedChangeSet.cloneForInspection(deployeds)) {
                discovered.addAll(tester.runInspectionTask((ConfigurationItem)deployed, context));
            }
        }
        Iterable existingDeployeds = Iterables.filter((Iterable)discovered, (Predicate)new Predicate<ConfigurationItem>(){

            public boolean apply(ConfigurationItem input) {
                return input instanceof Deployed && deployeds.contains(input);
            }
        });
        return Lists.newArrayList((Iterable)existingDeployeds);
    }

    protected boolean shouldCheckDeployedsDoNotExistBeforeCreating() {
        return this.deployedChangeSet.getDeployMode() == DeployedItestChangeSet.DeployMode.CREATE;
    }

    protected boolean shouldCreateDeployed() {
        return true;
    }

    protected boolean shouldCheckDeployedsCreatedCorrectly() {
        return true;
    }

    protected boolean shouldCheckDeployedsModifiedCorrectly() {
        return true;
    }

    protected boolean shouldModifyDeployeds() {
        return true;
    }

    protected boolean shouldDestroyDeployeds() {
        return this.deployedChangeSet.getDeployMode() == DeployedItestChangeSet.DeployMode.CREATE;
    }

    protected boolean shouldCheckDeployedsDoNotExistAfterDelete() {
        return this.deployedChangeSet.getDeployMode() == DeployedItestChangeSet.DeployMode.CREATE;
    }

    protected ConfigurationItem getCiToPerformInspectionOn(List<Type> typesToDiscover) {
        return null;
    }

    static {
        LocalBooter.bootWithoutGlobalContext();
    }
}

