/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support;

import com.google.common.collect.Sets;
import com.xebialabs.overcast.CloudHost;
import java.util.HashMap;
import java.util.Map;

public class CloudHostRegistry {
    private static final CloudHostRegistry instance = new CloudHostRegistry();
    private Map<String, StatefulHost> registry = new HashMap<String, StatefulHost>();

    private CloudHostRegistry() {
    }

    public static CloudHostRegistry getInstance() {
        return instance;
    }

    public void makeSureIsUp(CloudHost cloudHost) {
        if (this.isRegisteredAndRunning(cloudHost.getHostName())) {
            if (this.registry.get(cloudHost.getHostName()).state == StatefulHost.State.BROKEN) {
                throw new HostIsBrokenException("The cloud host which you are trying to put up is broken.");
            }
            if (this.registry.get(cloudHost.getHostName()).state == StatefulHost.State.STARTING) {
                throw new HostIsStillStartingException("The cloud host which you are trying to put up is still starting.");
            }
            return;
        }
        try {
            this.registry.put(cloudHost.getHostName(), StatefulHost.starting(cloudHost));
            cloudHost.setup();
            this.registry.put(cloudHost.getHostName(), StatefulHost.up(cloudHost));
        }
        catch (RuntimeException e) {
            this.registry.put(cloudHost.getHostName(), StatefulHost.broken(cloudHost));
            throw e;
        }
    }

    public void makeSureIsDown(CloudHost cloudHost) {
        if (!this.isRegisteredAndRunning(cloudHost.getHostName())) {
            return;
        }
        cloudHost.teardown();
        this.registry.put(cloudHost.getHostName(), StatefulHost.down(cloudHost));
    }

    public synchronized void makeSureAllAreDown() {
        for (StatefulHost entry : this.registry.values()) {
            this.makeSureIsDown(entry.host);
        }
    }

    public void makeSureAllDownInTheEnd() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                CloudHostRegistry.this.makeSureAllAreDown();
            }
        });
    }

    public void reset() {
        this.registry = new HashMap<String, StatefulHost>();
    }

    private boolean isRegisteredAndRunning(String key) {
        StatefulHost entry = this.registry.get(key);
        return entry != null && Sets.immutableEnumSet((Enum)StatefulHost.State.UP, (Enum[])new StatefulHost.State[]{StatefulHost.State.BROKEN, StatefulHost.State.STARTING}).contains((Object)entry.state);
    }

    public static class HostIsStillStartingException
    extends RuntimeException {
        public HostIsStillStartingException(String message) {
            super(message);
        }
    }

    public static class HostIsBrokenException
    extends RuntimeException {
        public HostIsBrokenException(String message) {
            super(message);
        }
    }

    private static class StatefulHost {
        private CloudHost host;
        private State state;

        private StatefulHost(CloudHost host, State state) {
            this.host = host;
            this.state = state;
        }

        static StatefulHost starting(CloudHost host) {
            return new StatefulHost(host, State.STARTING);
        }

        static StatefulHost up(CloudHost host) {
            return new StatefulHost(host, State.UP);
        }

        static StatefulHost down(CloudHost host) {
            return new StatefulHost(host, State.DOWN);
        }

        static StatefulHost broken(CloudHost host) {
            return new StatefulHost(host, State.BROKEN);
        }

        private static enum State {
            STARTING,
            UP,
            BROKEN,
            DOWN;

        }
    }
}

