/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support.junit;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class Parameterized
extends Suite {
    private static final List<Runner> NO_RUNNERS = Collections.emptyList();
    private final ArrayList<Runner> runners = new ArrayList();

    public Parameterized(Class<?> klass) throws Throwable {
        super(klass, NO_RUNNERS);
        Parameters parameters = (Parameters)this.getParametersMethod().getAnnotation(Parameters.class);
        this.createRunnersForParameters(this.allParameters(), parameters.name());
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    private Iterable<Object[]> allParameters() throws Throwable {
        Object parameters = this.getParametersMethod().invokeExplosively(null, new Object[0]);
        if (parameters instanceof Iterable) {
            return (Iterable)parameters;
        }
        throw this.parametersMethodReturnedWrongType();
    }

    private FrameworkMethod getParametersMethod() throws Exception {
        List methods = this.getTestClass().getAnnotatedMethods(Parameters.class);
        for (FrameworkMethod each : methods) {
            int modifiers = each.getMethod().getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            return each;
        }
        throw new Exception("No public static parameters method on class " + this.getTestClass().getName());
    }

    private void createRunnersForParameters(Iterable<Object[]> allParameters, String namePattern) throws InitializationError, Exception {
        try {
            int i = 0;
            for (Object[] parametersOfSingleTest : allParameters) {
                String name = this.nameFor(namePattern, i, parametersOfSingleTest);
                TestClassRunnerForParameters runner = new TestClassRunnerForParameters(this.getTestClass().getJavaClass(), parametersOfSingleTest, name);
                this.runners.add((Runner)runner);
                ++i;
            }
        }
        catch (ClassCastException e) {
            throw this.parametersMethodReturnedWrongType();
        }
    }

    private String nameFor(String namePattern, int index, Object[] parameters) {
        String finalPattern = namePattern.replaceAll("\\{index\\}", Integer.toString(index));
        String name = MessageFormat.format(finalPattern, parameters);
        return "[" + name + "]";
    }

    private Exception parametersMethodReturnedWrongType() throws Exception {
        String className = this.getTestClass().getName();
        String methodName = this.getParametersMethod().getName();
        String message = MessageFormat.format("{0}.{1}() must return an Iterable of arrays.", className, methodName);
        return new Exception(message);
    }

    private class TestClassRunnerForParameters
    extends BlockJUnit4ClassRunner {
        private final Object[] fParameters;
        private final String fName;

        TestClassRunnerForParameters(Class<?> type, Object[] parameters, String name) throws InitializationError {
            super(type);
            this.fParameters = parameters;
            this.fName = name;
        }

        public Object createTest() throws Exception {
            Object testClassInstance = null;
            List fields = this.getTestClass().getAnnotatedFields(Parameter.class);
            if (!fields.isEmpty()) {
                if (fields.size() > this.fParameters.length) {
                    throw new Exception(this.getTestClass().getName() + ": The number of annoted fields is upper than the number of available parameters.");
                }
                testClassInstance = this.getTestClass().getJavaClass().newInstance();
                for (FrameworkField f : fields) {
                    Field field = f.getField();
                    Parameter annot = field.getAnnotation(Parameter.class);
                    int index = annot.value();
                    try {
                        field.set(testClassInstance, this.fParameters[index]);
                    }
                    catch (IllegalArgumentException iare) {
                        throw new Exception(this.getTestClass().getName() + ": Trying to set " + field.getName() + " with the value " + this.fParameters[index] + " that is not the right type (" + this.fParameters[index].getClass().getSimpleName() + " instead of " + field.getType().getSimpleName() + ").", iare);
                    }
                    catch (IllegalAccessException iace) {
                        throw new Exception(this.getTestClass().getName() + ": Trying to set " + field.getName() + " but you doesn't allow JUnit to access it. Please make it public.", iace);
                    }
                    catch (IndexOutOfBoundsException ioobe) {
                        throw new Exception(this.getTestClass().getName() + ": Trying to set " + field.getName() + " but the index value of the annotation is too big.", ioobe);
                    }
                }
            } else {
                testClassInstance = this.getTestClass().getOnlyConstructor().newInstance(this.fParameters);
            }
            return testClassInstance;
        }

        protected String getName() {
            return this.fName;
        }

        protected String testName(FrameworkMethod method) {
            return method.getName() + this.getName();
        }

        protected void validateConstructor(List<Throwable> errors) {
            this.validateOnlyOneConstructor(errors);
            if (this.getTestClass().getAnnotatedFields(Parameter.class) != null && this.getTestClass().getAnnotatedFields(Parameter.class).size() > 0) {
                this.validateZeroArgConstructor(errors);
            }
        }

        protected Statement classBlock(RunNotifier notifier) {
            return this.childrenInvoker(notifier);
        }

        protected Annotation[] getRunnerAnnotations() {
            return new Annotation[0];
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Parameter {
        public int value() default 0;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Parameters {
        public String name() default "[{index}]";
    }
}

