package com.xebialabs.deployit.test.support;

import java.util.HashMap;
import java.util.Map;

import org.junit.ClassRule;

import com.xebialabs.overcast.CloudHost;

public class CloudHostRegistry {

    private static final CloudHostRegistry instance = new CloudHostRegistry();

    private enum State {
        UP, DOWN
    }

    private  Map<String, State> stateByName = new HashMap<String, State>();
    private Map<String, CloudHost> hostByName = new HashMap<String, CloudHost>();

    private CloudHostRegistry() {}

    public static CloudHostRegistry getInstance() {
        return instance;
    }

    public void makeSureIsUp(CloudHost cloudHost) {
        if (State.UP.equals(stateByName.get(cloudHost.getHostName()))) {
            return;
        }

        cloudHost.setup();
        stateByName.put(cloudHost.getHostName(), State.UP);
        hostByName.put(cloudHost.getHostName(), cloudHost);
    }

    public void makeSureIsDown(CloudHost cloudHost) {
        if (!State.UP.equals(stateByName.get(cloudHost.getHostName()))) {
            return;
        }
        cloudHost.teardown();
        stateByName.put(cloudHost.getHostName(), State.DOWN);
        hostByName.put(cloudHost.getHostName(), cloudHost);
    }

    public synchronized void makeSureAllAreDown() {
        for (Map.Entry<String, State> stringStateEntry : stateByName.entrySet()) {
            if (!State.UP.equals(stringStateEntry.getValue())) {
                continue;
            }

            hostByName.get(stringStateEntry.getKey()).teardown();
            stateByName.put(stringStateEntry.getKey(), State.DOWN);
        }

    }

    public void makeSureAllDownInTheEnd() {
        Runtime.getRuntime().addShutdownHook(new Thread() {
            @Override
            public void run() {
                makeSureAllAreDown();
            }
        });
    }

    public void reset() {
        stateByName = new HashMap<String, State>();
        hostByName = new HashMap<String, CloudHost>();
    }

}
