package com.xebialabs.deployit.engine.tasker;

import java.io.File;
import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;

import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Maps.newHashMap;

public class TaskSpecification {
    private final String description;
    private final String owner;
    private final List<TaskStep> steps;
    private final Map<String, String> metadata = newHashMap();
    private final List<ExecutionStateListener> listeners = newArrayList();
    private final File tempWorkDir;
    private TaskInspectionContext inspectionContext;
    private boolean recoverable;

    public TaskSpecification(String description, String owner, List<TaskStep> steps) {
        this(description, owner, steps, null);
    }

    public TaskSpecification(String description, String owner, List<TaskStep> steps, TaskInspectionContext inspectionContext) {
        this(description, owner, steps, inspectionContext, true);
    }

    public TaskSpecification(String description, String owner, List<TaskStep> steps, TaskInspectionContext inspectionContext, boolean recoverable) {
        this(description, owner, steps, inspectionContext, null, recoverable);
    }

    public TaskSpecification(String description, String owner, List<TaskStep> steps, TaskInspectionContext inspectionContext, File tempWorkDir, boolean recoverable) {
        this.description = description;
        this.owner = owner;
        this.steps = steps;
        this.inspectionContext = inspectionContext;
        this.tempWorkDir = tempWorkDir;
        this.recoverable = recoverable;
    }

    public String getDescription() {
        return description;
    }

    public List<TaskStep> getSteps() {
        return steps;
    }

    public String getOwner() {
        return owner;
    }

    public Map<String, String> getMetadata() {
        return metadata;
    }

    public List<ExecutionStateListener> getListeners() {
        return listeners;
    }

    public TaskInspectionContext getInspectionContext() {
        return inspectionContext;
    }

    public File getTempWorkDir() {
        return tempWorkDir;
    }

    public boolean isRecoverable() {
        return recoverable;
    }
}
