package com.xebialabs.deployit.engine.tasker;

import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static com.xebialabs.deployit.engine.api.execution.TaskExecutionState.*;
import static com.xebialabs.deployit.engine.spi.execution.Transitions.checkTransition;

class ArchiveTaskTrigger implements ExecutionStateListener {
    @Override
    public void stepStateChanged(StepExecutionStateEvent event) {
    }

    @Override
    public void taskStateChanged(TaskExecutionStateEvent event) {
        if (checkTransition(event, EXECUTED, DONE) || checkTransition(event, STOPPED, CANCELLED)) {
            logger.debug("Archiving task [{}].", event.task().getId());
            Engine.ARCHIVE_REF.get().archive(event.task());
            Engine.REGISTRY_REF.get().remove(event.task().getId());
        } else if (checkTransition(event, PENDING, CANCELLED) || checkTransition(event, QUEUED, CANCELLED)) {
            logger.info("Cleaning task [{}] which was cancelled, but never started.", event.task().getId());
            Engine.REGISTRY_REF.get().remove(event.task().getId());
        }
    }

    private static final Logger logger = LoggerFactory.getLogger(ArchiveTaskTrigger.class);
}
