/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.engine.tasker.TaskNotFoundException;
import com.xebialabs.deployit.engine.tasker.TaskRunner;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Registry {
    private ConcurrentMap<String, TaskRunner> reg = new ConcurrentHashMap<String, TaskRunner>();

    void register(TaskRunner task) {
        String id = task.getTask().getId();
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"task ID should have been set.");
        Preconditions.checkState((this.reg.putIfAbsent(id, task) == null ? 1 : 0) != 0, (String)"Task with ID [%s] has already been registered.", (Object[])new Object[]{id});
    }

    public TaskRunner retrieve(String id) {
        if (!this.reg.containsKey(id)) {
            throw new TaskNotFoundException("registry", id);
        }
        return (TaskRunner)this.reg.get(id);
    }

    public void remove(String id) {
        this.reg.remove(id);
    }

    public Collection<TaskRunner> tasks() {
        return this.reg.values();
    }

    public boolean hasTasks() {
        return !this.reg.isEmpty();
    }

    void clean() {
        this.reg.clear();
    }
}

