package com.xebialabs.deployit.engine.tasker;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContextListener;

import static com.xebialabs.deployit.engine.api.execution.TaskExecutionState.EXECUTED;
import static com.xebialabs.deployit.engine.api.execution.TaskExecutionState.EXECUTING;
import static com.xebialabs.deployit.engine.api.execution.TaskExecutionState.STOPPED;
import static com.xebialabs.deployit.engine.spi.execution.Transitions.checkTransition;

public class OldExecutionContextListenerCleanupTrigger implements ExecutionStateListener {
    @Override
    public void stepStateChanged(final StepExecutionStateEvent event) {
    }

    @Override
    public void taskStateChanged(final TaskExecutionStateEvent event) {
        if (checkTransition(event, EXECUTING, EXECUTED) || checkTransition(event, EXECUTING, STOPPED)) {
            TaskExecutionContext context = ((Task) event.task()).getContext();
            cleanContext(context);
        }
    }

    private void cleanContext(final TaskExecutionContext context) {
        for (Map.Entry<String, Object> entry : context.getAttributes().entrySet()) {
            if (entry.getValue() instanceof ExecutionContextListener) {
                logger.info("Cleaning up [{}] which is an [{}]", entry.getKey(), entry.getValue());
                cleanupListener((ExecutionContextListener) entry.getValue());

            }
        }
    }

    private void cleanupListener(final ExecutionContextListener listener) {
        try {
            listener.contextDestroyed();
        } catch (RuntimeException re) {
            logger.error("Exception while cleaning up object {} in execution context", listener);
            logger.error("Exception is: ", re);
        }
    }

    private static final Logger logger = LoggerFactory.getLogger(OldExecutionContextListenerCleanupTrigger.class);
}
