package com.xebialabs.deployit.engine.unicode;

public enum BOM {
    UTF8("UTF-8", new byte[] { (byte) 0xEF, (byte) 0xBB, (byte) 0xBF }),
    UTF16BE("UTF-16BE", new byte[] { (byte) 0xFE, (byte) 0xFF }),
    UTF16LE("UTF-16LE", new byte[] { (byte) 0xFF, (byte) 0xFE }),
    //UTF32BE("UTF-32BE", new byte[] { 0x00, 0x00, (byte) 0xFE, (byte) 0xFF }),
    //UTF32LE("UTF-32LE", new byte[] { (byte) 0xFF, (byte) 0xFE, 0x00, 0x00 }),
    NONE("NONE", new byte[] {});

    BOM(String encoding, byte[] bom) {
        this.encoding = encoding;
        this.bom = bom;
    }

    public String getEncoding() {
        return encoding;
    }

    public int getSize() {
        return bom.length;
    }

    public byte[] getBom() {
        return bom.clone();
    }

    private final String encoding;
    private final byte[] bom;
};