/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RemoteDescriptorRegistry
extends DescriptorRegistry {
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private Map<Type, Descriptor> descriptors = Maps.newHashMap();
    private Multimap<Type, Type> subtypes = HashMultimap.create();

    protected RemoteDescriptorRegistry(DescriptorRegistryId id) {
        super(id);
    }

    protected boolean isLocal() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Descriptor> _getDescriptors() {
        this.readLock.lock();
        try {
            Collection<Descriptor> collection = this.descriptors.values();
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Type> _getSubtypes(Type supertype) {
        this.readLock.lock();
        try {
            Collection collection = this.subtypes.get((Object)supertype);
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Descriptor _getDescriptor(Type type) {
        this.readLock.lock();
        try {
            Descriptor descriptor = this.descriptors.get(type);
            return descriptor;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _exists(Type type) {
        this.readLock.lock();
        try {
            boolean bl = this.descriptors.containsKey(type);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public static void boot(DeployitCommunicator communicator) {
        RemoteDescriptorRegistry registry = new RemoteDescriptorRegistry(communicator.getConfig());
        DescriptorRegistry.add((DescriptorRegistry)registry);
        registry.reboot(communicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reboot(DeployitCommunicator communicator) {
        this.writeLock.lock();
        try {
            List list = communicator.getProxies().getMetadataService().listDescriptors();
            this.reboot(list);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reboot(List<Descriptor> list) {
        this.writeLock.lock();
        try {
            HashMap newDescriptorsMap = Maps.newHashMap();
            HashMultimap newSubtypesMap = HashMultimap.create();
            for (Descriptor descriptor : list) {
                newDescriptorsMap.put(descriptor.getType(), descriptor);
                for (Type type : descriptor.getSuperClasses()) {
                    newSubtypesMap.put((Object)type, (Object)descriptor.getType());
                }
                for (Type type : descriptor.getInterfaces()) {
                    newSubtypesMap.put((Object)type, (Object)descriptor.getType());
                }
            }
            this.descriptors = newDescriptorsMap;
            this.subtypes = newSubtypesMap;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Collection<Descriptor> getLoadedDescriptors() {
        return this._getDescriptors();
    }

    public Descriptor getLoadedDescriptor(Type type) {
        return this._getDescriptor(type);
    }

    public Descriptor getLoadedDescriptor(String prefixedName) {
        return this.getLoadedDescriptor(this.lookupType(prefixedName));
    }

    public Descriptor getLoadedDescriptor(String prefix, String name) {
        return this.getLoadedDescriptor(this.lookupType(prefix, name));
    }
}

