package com.xebialabs.deployit.booter.remote.xml.adapter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.base.Joiner;
import com.thoughtworks.xstream.converters.DataHolder;

import com.xebialabs.deployit.booter.remote.resteasy.BooterConfigHolder;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.CiWriter;

import static com.google.common.collect.Lists.newArrayList;

/**
 * DEPL-5987 Make 3.9.x integration plugins compatible with 4.0.0.
 */
public class OrchestratorPropertyAdapter implements CiPropertyAdapter {
    private static final Logger logger = LoggerFactory.getLogger(OrchestratorPropertyAdapter.class);
    public static final String SEPARATOR = ",";

    @Override
    public void writeProperty(final ConfigurationItem configurationItem, final PropertyDescriptor propertyDescriptor, final CiWriter writer, final int ciRefsFromLevel) {
        logger.debug("Property 'orchestrator' marshalled to server schema version: {}", BooterConfigHolder.getKey());
        Object value = propertyDescriptor.get(configurationItem);
        if (value == null) return;

        writer.startProperty(propertyDescriptor.getName());
        writer.valuesAsStrings(newArrayList(value.toString().split(SEPARATOR)));
        writer.endProperty();
    }

    @Override
    public void readProperty(final CiReader reader, final PropertyDescriptor propertyDescriptor, final ConfigurationItem configurationItem) {
        logger.debug("Property 'orchestrator' unmarshalled from server schema version: {}", BooterConfigHolder.getKey());
        propertyDescriptor.set(configurationItem, Joiner.on(SEPARATOR).join(reader.getStringValues()));
    }

    @Override
    public boolean isApplicable(final DataHolder context, final ConfigurationItem configurationItem, final PropertyDescriptor propertyDescriptor) {
        boolean isOrchestratorProperty = "orchestrator".equals(propertyDescriptor.getName());
        boolean configurationItemIsDeployedApplication = configurationItem.getType().instanceOf(Type.valueOf("udm.DeployedApplication"));
        boolean serverPropertyTypeIsNotString = !PropertyKind.STRING.equals(propertyDescriptor.getKind());

        return  isOrchestratorProperty && configurationItemIsDeployedApplication && serverPropertyTypeIsNotString;
    }

}
