package com.xebialabs.deployit.booter.remote.xml;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;

import com.xebialabs.deployit.booter.remote.execution.RemoteTaskState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.engine.xml.AbstractTaskConverter;
import com.xebialabs.deployit.engine.xml.Converters;
import com.xebialabs.deployit.engine.xml.DateTimeAdapter;
import com.xebialabs.deployit.engine.xml.XStreamProvider;

import java.util.List;

@XStreamProvider(readable = TaskState.class, tagName = "task")
public class TaskConverter extends AbstractTaskConverter {
    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        RemoteTaskState t = new RemoteTaskState();
        t.setId(reader.getAttribute("id"));
        t.setCurrentStepNr(Integer.valueOf(reader.getAttribute("currentStep")));
        t.setNrSteps(Integer.valueOf(reader.getAttribute("totalSteps")));
        t.setFailureCount(Integer.valueOf(reader.getAttribute("failures")));
        t.setState(TaskExecutionState.valueOf(reader.getAttribute("state")));
        t.setOwner(reader.getAttribute("owner"));

        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("description".equals(reader.getNodeName())) {
                t.setDescription(reader.getValue());
            } else if ("startDate".equals(reader.getNodeName())) {
                t.setStartDate(new DateTimeAdapter().fromString(reader.getValue()));
            } else if ("completionDate".equals(reader.getNodeName())) {
                t.setCompletionDate(new DateTimeAdapter().fromString(reader.getValue()));
            } else if ("metadata".equals(reader.getNodeName())) {
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    t.getMetadata().put(reader.getNodeName(), reader.getValue());
                    reader.moveUp();
                }
            } else if ("steps".equals(reader.getNodeName())) {
                List<StepState> stepStates = Converters.readList(t, StepState.class, reader, context);
                t.setSteps(stepStates);
            }
            reader.moveUp();
        }
        return t;
    }
}
