/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote;

import java.io.Serializable;

public class BooterConfig
implements Serializable {
    private Protocol protocol = Protocol.HTTP;
    private String host;
    private int port = -1;
    private String context = "deployit";
    private String username;
    private String password;

    public static Builder builder() {
        return new Builder();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port == -1 ? (this.protocol == Protocol.HTTPS ? 4517 : 4516) : this.port;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getContext() {
        if (!this.context.endsWith("deployit")) {
            this.context = this.context + "/deployit";
        }
        if (this.context.startsWith("/")) {
            this.context = this.context.substring(1);
        }
        return this.context;
    }

    public String getUrl() {
        return String.format("%s://%s:%d/%s", this.protocol.getProtocol(), this.host, this.getPort(), this.getContext());
    }

    public boolean isSecure() {
        return this.protocol == Protocol.HTTPS;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooterConfig that = (BooterConfig)o;
        if (!this.host.equals(that.host)) {
            return false;
        }
        if (!this.password.equals(that.password)) {
            return false;
        }
        if (this.protocol != that.protocol) {
            return false;
        }
        return this.username.equals(that.username);
    }

    public int hashCode() {
        int result = this.protocol.hashCode();
        result = 31 * result + this.host.hashCode();
        result = 31 * result + this.username.hashCode();
        result = 31 * result + this.password.hashCode();
        return result;
    }

    public static class Builder {
        private BooterConfig config = new BooterConfig();

        public Builder withProtocol(Protocol protocol) {
            this.config.protocol = protocol;
            return this;
        }

        public Builder withHost(String host) {
            this.config.host = host;
            return this;
        }

        public Builder withPort(int port) {
            this.config.port = port;
            return this;
        }

        public Builder withContext(String context) {
            this.config.context = context;
            return this;
        }

        public Builder withCredentials(String username, String password) {
            this.config.username = username;
            this.config.password = password;
            return this;
        }

        public BooterConfig build() {
            return this.config;
        }
    }

    public static enum Protocol {
        HTTP("http"),
        HTTPS("https");

        private String protocol;

        private Protocol(String protocol) {
            this.protocol = protocol;
        }

        public String getProtocol() {
            return this.protocol;
        }
    }
}

