package com.xebialabs.deployit.booter.remote.resteasy;

import org.jboss.resteasy.client.core.extractors.BodyEntityExtractor;
import org.jboss.resteasy.client.core.extractors.ClientRequestContext;
import org.jboss.resteasy.client.core.extractors.EntityExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Method;

public class DeployitBodyEntityExtractor extends BodyEntityExtractor {
    public DeployitBodyEntityExtractor(Method method) {
        super(method);
    }

    @Override
    public Object extractEntity(ClientRequestContext context, Object... args) {
        try {
            return super.extractEntity(context, args);
        } catch (DeployitClientException dce) {
            if (dce.hasEntity()) {
                logger.debug("Caught a DeployitClientException with an entity");
                return dce.getEntity();
            }
            throw dce;
        }
    }

    private static final Logger logger = LoggerFactory.getLogger(DeployitBodyEntityExtractor.class);
}
