package com.xebialabs.deployit.booter.remote.resteasy;

import com.xebialabs.deployit.engine.xml.XStreamReaderWriter;

import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.BaseClientResponse;
import org.jboss.resteasy.client.core.ClientErrorInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.ws.rs.Produces;
import javax.ws.rs.ext.Provider;

@Provider
public class InternalServerErrorClientResponseInterceptor implements ClientErrorInterceptor {

    @Override
    public void handle(ClientResponse<?> clientResponse) throws DeployitClientException {
        logger.info("Handling Error Response, status code: {}", clientResponse.getStatus());
        tryDeployitException(clientResponse);
        tryUnhandledException(clientResponse);
    }

    private void tryUnhandledException(final ClientResponse<?> clientResponse) {
        if (clientResponse.getHeaders().containsKey("Unhandled-Exception")) {
            logger.debug("Found unhandled header");
            final String exceptionType = clientResponse.getHeaders().getFirst("Exception-Type");
            try {
                String unhandledMessage = clientResponse.getEntity(String.class);
                throw new RuntimeException(String.format("%s: %s", exceptionType, unhandledMessage));
            } finally {
                ((BaseClientResponse) clientResponse).releaseConnection();
            }
        }
    }

    private void tryDeployitException(final ClientResponse<?> clientResponse) {
        if (clientResponse.getHeaders().containsKey("X-Deployit-Exception")) {
            logger.debug("Found Deployit header");
            try {
                final String messages = clientResponse.getEntity(String.class);
                if (clientResponse.getHeaders().containsKey("X-Entity")) {
                    Object o = XStreamReaderWriter.getConfiguredXStream().fromXML(messages);
                    throw new DeployitClientException(o, clientResponse.getStatus());
                }
                throw new DeployitClientException(messages, clientResponse.getStatus());
            } finally {
                ((BaseClientResponse) clientResponse).releaseConnection();
            }
        }
    }

    private static final Logger logger = LoggerFactory.getLogger(InternalServerErrorClientResponseInterceptor.class);
}
