package com.xebialabs.deployit.booter.remote.execution;

import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;

import org.joda.time.DateTime;

import java.util.List;
import java.util.Map;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Maps.newHashMap;

public class RemoteTaskState implements TaskWithSteps {
    private TaskExecutionState state;
    private String id;
    private String description;
    private DateTime startDate;
    private DateTime completionDate;
    private int nrSteps;
    private int currentStepNr;
    private Map<String, String> metadata = newHashMap();
    private int failureCount;
    private List<StepState> steps = newArrayList();
    private String owner;

    @Override
    public TaskExecutionState getState() {
        return state;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public DateTime getStartDate() {
        return startDate;
    }

    @Override
    public DateTime getCompletionDate() {
        return completionDate;
    }

    @Override
    public int getNrSteps() {
        return nrSteps;
    }

    @Override
    public int getCurrentStepNr() {
        return currentStepNr;
    }

    @Override
    public Map<String, String> getMetadata() {
        return metadata;
    }

    @Override
    public int getFailureCount() {
        return failureCount;
    }

    @Override
    public String getOwner() {
        return owner;
    }

    @Override
    public List<StepState> getSteps() {
        return steps;
    }

    @Override
    public StepState getStep(int stepNr) {
        checkArgument(stepNr > 0 && stepNr <= steps.size(), "Not a valid step number [%s]", stepNr);
        return steps.get(stepNr - 1);
    }

    public void setState(TaskExecutionState state) {
        this.state = state;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setStartDate(DateTime startDate) {
        this.startDate = startDate;
    }

    public void setCompletionDate(DateTime completionDate) {
        this.completionDate = completionDate;
    }

    public void setNrSteps(int nrSteps) {
        this.nrSteps = nrSteps;
    }

    public void setCurrentStepNr(int currentStepNr) {
        this.currentStepNr = currentStepNr;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setFailureCount(int failureCount) {
        this.failureCount = failureCount;
    }

    public void setSteps(List<StepState> steps) {
        this.steps = steps;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }
}
