/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.booter.remote.client;

import com.google.common.collect.Lists;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.core.MapBackedDataHolder;
import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter;

import java.util.List;

public class ClientXStreamReaderWriter extends XStreamReaderWriter {

    private static final List<String> blacklistClasses = Lists.newArrayList(
            "com.xebialabs.deployit.core.rest.xml.DescriptorWriter"
    );

    private final BooterConfig booterConfig;

    public ClientXStreamReaderWriter(final BooterConfig booterConfig) {
        this.booterConfig = booterConfig;
    }

    @Override
    protected Converter constructConverter(final Class<?> clazz) {
        if (blacklistClasses.contains(clazz.getName())) {
            return null;
        }
        return super.constructConverter(clazz);
    }

    @Override
    protected DataHolder createDataHolder() {
        MapBackedDataHolder dataHolder = new MapBackedDataHolder();
        dataHolder.put("BOOTER_CONFIG", booterConfig.getKey());
        return dataHolder;
    }
}
