/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote;

import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.plugin.api.reflect.BaseDescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;
import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RemoteDescriptorRegistry
extends BaseDescriptorRegistry {
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private Map<Type, Descriptor> descriptors = new HashMap<Type, Descriptor>();
    private Map<Type, List<Type>> subtypes = new HashMap<Type, List<Type>>();

    protected RemoteDescriptorRegistry(DescriptorRegistryId id) {
        super(id);
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isDefault() {
        return false;
    }

    public Collection<Descriptor> _getDescriptors() {
        this.readLock.lock();
        try {
            Collection<Descriptor> collection = this.descriptors.values();
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Collection<Type> _getSubtypes(Type supertype) {
        this.readLock.lock();
        try {
            Collection<Type> collection = this.getFromTypeMap(this.subtypes, supertype);
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Descriptor _getDescriptor(Type type) {
        if (!this.descriptors.containsKey(type)) {
            throw new IllegalArgumentException(String.format("DescriptorRegistry does not know about type [%s]", type));
        }
        this.readLock.lock();
        try {
            Descriptor descriptor = this.descriptors.get(type);
            return descriptor;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean _exists(Type type) {
        this.readLock.lock();
        try {
            boolean bl = this.descriptors.containsKey(type);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public static void boot(DeployitCommunicator communicator) {
        RemoteDescriptorRegistry registry = new RemoteDescriptorRegistry(communicator.getConfig());
        DescriptorRegistry.add((IDescriptorRegistry)registry);
        registry.reboot(communicator);
    }

    public void reboot(DeployitCommunicator communicator) {
        this.writeLock.lock();
        try {
            List list = communicator.getProxies().getMetadataService().listDescriptors();
            this.reboot(list);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reboot(List<Descriptor> list) {
        this.writeLock.lock();
        try {
            this.descriptors = new HashMap<Type, Descriptor>();
            this.subtypes = new HashMap<Type, List<Type>>();
            for (Descriptor descriptor : list) {
                this.register(descriptor);
                for (Type superType : descriptor.getSuperClasses()) {
                    this.registerSubtype(superType, descriptor.getType());
                }
                for (Type superType : descriptor.getInterfaces()) {
                    this.registerSubtype(superType, descriptor.getType());
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void register(Descriptor descriptor) {
        this.descriptors.put(descriptor.getType(), descriptor);
    }

    public void registerSubtype(Type supertype, Type subtype) {
        this.addToTypeMap(this.subtypes, supertype, subtype);
    }

    public Collection<Descriptor> getLoadedDescriptors() {
        return this._getDescriptors();
    }

    public Descriptor getLoadedDescriptor(Type type) {
        return this._getDescriptor(type);
    }

    public Descriptor getLoadedDescriptor(String prefixedName) {
        return this.getLoadedDescriptor(this.lookupType(prefixedName));
    }

    public Descriptor getLoadedDescriptor(String prefix, String name) {
        return this.getLoadedDescriptor(this.lookupType(prefix, name));
    }

    private void addToTypeMap(Map<Type, List<Type>> map, Type key, Type value) {
        List<Type> collection = map.get(key);
        if (null == collection) {
            collection = new ArrayList<Type>();
        }
        collection.add(value);
        map.put(key, collection);
    }

    private Collection<Type> getFromTypeMap(Map<Type, List<Type>> map, Type key) {
        List<Type> list = map.get(key);
        if (null == list) {
            list = new ArrayList<Type>();
        }
        return list;
    }
}

