/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.booter.remote.xml;

import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.xebialabs.deployit.booter.remote.execution.RemoteBlockState;
import com.xebialabs.deployit.engine.api.execution.BlockExecutionState;
import com.xebialabs.deployit.engine.api.execution.BlockState;

abstract class BlockReader {

    protected final HierarchicalStreamReader reader;

    protected BlockReader(HierarchicalStreamReader reader) {
        this.reader = reader;
    }

    abstract BlockState read();

    protected void setCommonPropertiesOn(final RemoteBlockState block) {
        block.setId(reader.getAttribute("id"));
        block.setDescription(reader.getAttribute("description"));
        block.setState(BlockExecutionState.valueOf(reader.getAttribute("state")));
        block.setHasSteps(Boolean.valueOf(reader.getAttribute("hasSteps")));
    }
}
