/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.booter.remote.invoker;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class DefaultsInvoker extends InvocationHandlerInvoker {

    private MethodHandles.Lookup lookup;

    public DefaultsInvoker(InvocationHandler invocationHandler, MethodHandles.Lookup lookup) {
        super(invocationHandler);
        this.lookup = lookup;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.isDefault()) {
            return lookup
                    .unreflectSpecial(method, method.getDeclaringClass())
                    .bindTo(proxy)
                    .invokeWithArguments(args);
        }
        return super.invoke(proxy, method, args);
    }
}
