/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.booter.remote.execution;

import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;

import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.StepState;

public class RemoteStepState implements StepState {
    private String description;
    private StepExecutionState state;
    private String log;
    private DateTime startDate;
    private DateTime completionDate;
    private int failureCount;
    private boolean skippable;

    private Map<String, String> metadata = new HashMap<>();

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public StepExecutionState getState() {
        return state;
    }

    @Override
    public String getLog() {
        return log;
    }

    @Override
    public DateTime getStartDate() {
        return startDate;
    }

    @Override
    public DateTime getCompletionDate() {
        return completionDate;
    }

    @Override
    public int getFailureCount() {
        return failureCount;
    }

    @Override
    public Map<String, String> getMetadata() {
        return metadata;
    }

    @Override
    public boolean getSkippable() {
        return skippable;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setState(StepExecutionState state) {
        this.state = state;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public void setStartDate(DateTime startDate) {
        this.startDate = startDate;
    }

    public void setCompletionDate(DateTime completionDate) {
        this.completionDate = completionDate;
    }

    public void setFailureCount(int failureCount) {
        this.failureCount = failureCount;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setSkippable(boolean skippable) {
        this.skippable = skippable;
    }

    @Override
    public String toString() {
        return description;
    }
}
