/**
 * Copyright 2014-2018 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.booter.remote;

import java.util.*;
import java.util.regex.Pattern;

import javax.xml.bind.DatatypeConverter;

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;

class PropertyConverter {
    public static final Pattern SPLIT_PATTERN = Pattern.compile("\\s*,\\s*");

    public static Object convertValue(PropertyKind kind, Object value) {
        if (value == null) {
            return null;
        }

        if (value instanceof String) {
            if (kind.equals(PropertyKind.BOOLEAN)) {
                return Boolean.valueOf((String) value);
            }
            if (kind.equals(PropertyKind.INTEGER)) {
                return Integer.valueOf((String) value);
            }
            if (kind.equals(PropertyKind.DATE)) {
                return DatatypeConverter.parseDateTime((String) value).getTime();
            }
            if (kind.equals(PropertyKind.LIST_OF_STRING)) {
                return splitToList((String) value);
            }
            if (kind.equals(PropertyKind.SET_OF_STRING)) {
                return new HashSet<>(splitToList((String) value));
            }
            if (kind.equals(PropertyKind.MAP_STRING_STRING)) {
                return splitToKeyValueMap((String) value);
            }
        }

        return value;
    }

    private static List<String> splitToList(String value) {
        List<String> r = new ArrayList<>();
        for (String s : SPLIT_PATTERN.split(value.trim())) {
            if (!s.isEmpty()) {
                r.add(s);
            }
        }
        return r;
    }

    private static Map<String, String> splitToKeyValueMap(String value) {
        Map<String, String> m = new HashMap<>();
        for (String s : SPLIT_PATTERN.split(value.trim())) {
            if (!s.isEmpty()) {
                int idx = s.indexOf(':');
                if(idx == -1) {
                    throw new IllegalArgumentException(String.format("Invalid MAP_STRING_STRING format '%s' entry '%s'", value, s));
                }
                if(m.put(s.substring(0, idx), s.substring(idx+1)) != null) {
                    throw new IllegalArgumentException(String.format("Invalid MAP_STRING_STRING '%s' duplicate entry '%s'", value, s));
                }
            }
        }
        return m;
    }
}

