/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote.execution;

import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskPackageDependency;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class RemoteTaskState
implements TaskWithSteps {
    private TaskExecutionState state;
    private String id;
    private String description;
    private DateTime startDate;
    private DateTime completionDate;
    private int nrSteps;
    private List<Integer> currentStepNrs = new ArrayList<Integer>();
    private Map<String, String> metadata = new HashMap<String, String>();
    private int failureCount;
    private List<StepState> steps = new ArrayList<StepState>();
    private String owner;
    private DateTime scheduledDate;
    private List<TaskPackageDependency> packageDependencies = new ArrayList<TaskPackageDependency>();

    public TaskExecutionState getState() {
        return this.state;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public DateTime getScheduledDate() {
        return this.scheduledDate;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public DateTime getCompletionDate() {
        return this.completionDate;
    }

    public int getNrSteps() {
        return this.nrSteps;
    }

    @Deprecated
    public int getCurrentStepNr() {
        return this.currentStepNrs.size() > 0 ? this.currentStepNrs.get(0) : 0;
    }

    public List<Integer> getCurrentStepNrs() {
        return this.currentStepNrs;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public String getOwner() {
        return this.owner;
    }

    public List<StepState> getSteps() {
        return this.steps;
    }

    public StepState getStep(int stepNr) {
        if (stepNr <= 0 || stepNr > this.steps.size()) {
            throw new IllegalArgumentException(String.format("Not a valid step number [%s]", stepNr));
        }
        return this.steps.get(stepNr - 1);
    }

    public void setState(TaskExecutionState state) {
        this.state = state;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setStartDate(DateTime startDate) {
        this.startDate = startDate;
    }

    public void setCompletionDate(DateTime completionDate) {
        this.completionDate = completionDate;
    }

    public void setScheduledDate(DateTime scheduledDate) {
        this.scheduledDate = scheduledDate;
    }

    public void setNrSteps(int nrSteps) {
        this.nrSteps = nrSteps;
    }

    @Deprecated
    public void setCurrentStepNr(int currentStepNr) {
        this.setCurrentStepNrs(Collections.singletonList(currentStepNr));
    }

    public void setCurrentStepNrs(List<Integer> currentStepNrs) {
        this.currentStepNrs = new ArrayList<Integer>(currentStepNrs);
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setFailureCount(int failureCount) {
        this.failureCount = failureCount;
    }

    public void setSteps(List<StepState> steps) {
        this.steps = steps;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String toString() {
        return this.id;
    }

    public List<TaskPackageDependency> getPackageDependencies() {
        return this.packageDependencies;
    }
}

