/**
 * Copyright © 2014-2016 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.booter.remote.execution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.engine.api.execution.TaskPackageDependency;
import org.joda.time.DateTime;

import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;

public class RemoteTaskWithBlock implements TaskWithBlock {

    private String id;
    private String description;
    private TaskExecutionState state;
    private String owner;
    private DateTime scheduledDate;
    private DateTime startDate;
    private DateTime completionDate;
    private int failureCount;
    private Map<String,String> metadata = new HashMap<>();
    private List<String> activeBlocks = new ArrayList<>();
    private BlockState block;
    private List<TaskPackageDependency> packageDependencies = new ArrayList<>();

    @Override
    public String getId() {
        return id;
    }

    public void setId(final String id) {
        this.id = id;
    }

    @Override
    public String getDescription() {
        return description;
    }

    public void setDescription(final String description) {
        this.description = description;
    }

    @Override
    public TaskExecutionState getState() {
        return state;
    }

    public void setState(final TaskExecutionState state) {
        this.state = state;
    }

    @Override
    public String getOwner() {
        return owner;
    }

    public void setOwner(final String owner) {
        this.owner = owner;
    }

    @Override
    public DateTime getScheduledDate() {
        return scheduledDate;
    }

    public void setScheduledDate(final DateTime scheduledDate) {
        this.scheduledDate = scheduledDate;
    }

    @Override
    public DateTime getStartDate() {
        return startDate;
    }

    public void setStartDate(final DateTime startDate) {
        this.startDate = startDate;
    }

    @Override
    public DateTime getCompletionDate() {
        return completionDate;
    }

    public void setCompletionDate(final DateTime completionDate) {
        this.completionDate = completionDate;
    }

    @Override
    public int getFailureCount() {
        return failureCount;
    }

    public void setFailureCount(final int failureCount) {
        this.failureCount = failureCount;
    }

    @Override
    public Map<String, String> getMetadata() {
        return metadata;
    }

    public void setMetadata(final Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Override
    public List<String> getActiveBlocks() {
        return activeBlocks;
    }

    public void setActiveBlocks(final List<String> activeBlocks) {
        this.activeBlocks = activeBlocks;
    }

    @Override
    public BlockState getBlock() {
        return block;
    }

    public void setBlock(final BlockState block) {
        this.block = block;
    }

    @Override
    public List<TaskPackageDependency> getPackageDependencies() {
        return packageDependencies;
    }
}
