/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote.resteasy;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.core.MapBackedDataHolder;
import com.xebialabs.deployit.booter.remote.resteasy.DeployitClientException;
import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter;
import java.io.Reader;
import java.io.StringReader;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.BaseClientResponse;
import org.jboss.resteasy.client.core.ClientErrorInterceptor;
import org.jboss.resteasy.spi.ReaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class InternalServerErrorClientResponseInterceptor
implements ClientErrorInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(InternalServerErrorClientResponseInterceptor.class);

    public void handle(ClientResponse<?> clientResponse) throws DeployitClientException {
        logger.info("Handling Error Response, status code: {}", (Object)clientResponse.getStatus());
        this.tryDeployitException(clientResponse);
        this.tryUnhandledException(clientResponse);
    }

    private void tryUnhandledException(ClientResponse<?> clientResponse) {
        if (clientResponse.getHeaders().containsKey((Object)"X-Unhandled-Exception")) {
            logger.debug("Found unhandled header");
            Object exceptionType = clientResponse.getHeaders().getFirst((Object)"X-Exception-Type");
            Object path = clientResponse.getHeaders().getFirst((Object)"X-Path");
            try {
                String messages = this.tryToReadEntity(clientResponse);
                throw new RuntimeException(String.format("%s [%s]: %s", exceptionType, path, messages != null ? messages : ""));
            }
            catch (Throwable throwable) {
                ((BaseClientResponse)clientResponse).releaseConnection();
                throw throwable;
            }
        }
    }

    private void tryDeployitException(ClientResponse<?> clientResponse) {
        if (clientResponse.getHeaders().containsKey((Object)"X-Deployit-Exception")) {
            logger.debug("Found XL Deploy header");
            try {
                Object exceptionType = clientResponse.getHeaders().getFirst((Object)"X-Exception-Type");
                Object path = clientResponse.getHeaders().getFirst((Object)"X-Path");
                String messages = this.tryToReadEntity(clientResponse);
                if (clientResponse.getHeaders().containsKey((Object)"X-Entity") && messages != null) {
                    XStream xStream = XStreamReaderWriter.getConfiguredXStream();
                    MapBackedDataHolder dataHolder = new MapBackedDataHolder();
                    dataHolder.put((Object)"BOOTER_CONFIG", clientResponse.getHeaders().getFirst((Object)"BOOTER_CONFIG"));
                    Object o = xStream.unmarshal(XStreamReaderWriter.HIERARCHICAL_STREAM_DRIVER.createReader((Reader)new StringReader(messages)), null, (DataHolder)dataHolder);
                    throw new DeployitClientException(o, clientResponse.getStatus());
                }
                throw new DeployitClientException(String.format("%s [%s]: %s", exceptionType, path, messages != null ? messages : ""), clientResponse.getStatus());
            }
            catch (Throwable throwable) {
                ((BaseClientResponse)clientResponse).releaseConnection();
                throw throwable;
            }
        }
    }

    private String tryToReadEntity(ClientResponse<?> clientResponse) {
        String messages = null;
        try {
            messages = (String)clientResponse.getEntity(String.class);
        }
        catch (ReaderException readerException) {
            // empty catch block
        }
        return messages;
    }
}

