/**
 * Copyright © 2014-2015 XebiaLabs B.V. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.booter.remote.execution;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.CompositeBlockState;

public class RemoteCompositeBlockState extends RemoteBlockState implements CompositeBlockState {

    private boolean parallel;
    private List<BlockState> blocks = new ArrayList<>();

    @Override
    public boolean isParallel() {
        return parallel;
    }

    @Override
    public List<BlockState> getBlocks() {
        return blocks;
    }

    public void setParallel(final boolean parallel) {
        this.parallel = parallel;
    }

    public void setBlocks(final List<BlockState> blocks) {
        this.blocks = blocks;
    }

}
