/**
 * Copyright © 2014-2015 XebiaLabs B.V. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.booter.remote.xml;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.xebialabs.deployit.booter.remote.execution.RemoteCompositeBlockState;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.xltype.serialization.xstream.Converters;

import java.util.List;

class RemoteCompositeBlockReader extends BlockReader {
    private UnmarshallingContext context;

    public RemoteCompositeBlockReader(HierarchicalStreamReader reader, UnmarshallingContext context) {
        super(reader);
        this.context = context;
    }

    public BlockState read() {
        RemoteCompositeBlockState block = new RemoteCompositeBlockState();

        setCommonPropertiesOn(block);

        block.setParallel(Boolean.parseBoolean(reader.getAttribute("parallel")));
        List<BlockState> blockStates = Converters.readList(block, BlockState.class, reader, context);

        block.setBlocks(blockStates);

        return block;
    }

}
