/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote;

import com.google.common.base.Objects;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpRequestInterceptor;

public class BooterConfig
implements Serializable,
DescriptorRegistryId {
    private Protocol protocol = Protocol.HTTP;
    private String host;
    private int port = -1;
    private String proxyHost;
    private int proxyPort = -1;
    private String context = "deployit";
    private String username;
    private String password;
    private int connectionPoolSize;
    private int socketTimeout = 1000;
    private List<HttpRequestInterceptor> httpRequestInterceptors = new ArrayList<HttpRequestInterceptor>();

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BooterConfig config) {
        return new Builder(config);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port == -1 ? (this.protocol == Protocol.HTTPS ? 4517 : 4516) : this.port;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public List<HttpRequestInterceptor> getHttpRequestInterceptors() {
        return this.httpRequestInterceptors;
    }

    public String getContext() {
        if (!this.context.endsWith("deployit")) {
            this.context = this.context + "/deployit";
        }
        if (this.context.startsWith("/")) {
            this.context = this.context.substring(1);
        }
        return this.context;
    }

    public String getUrl() {
        return String.format("%s://%s:%d/%s", this.protocol.getProtocol(), this.host, this.getPort(), this.getContext());
    }

    public String getKey() {
        String key = String.format("%s://%s:%s@%s:%d/%s", this.protocol.getProtocol(), this.username, this.password, this.host, this.getPort(), this.getContext());
        if (this.isProxied()) {
            key = String.format("%s via proxy %s:%s", key, this.proxyHost, this.proxyPort);
        }
        return key;
    }

    public boolean isSecure() {
        return this.protocol == Protocol.HTTPS;
    }

    public boolean isProxied() {
        return this.proxyPort != -1 && this.proxyHost != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooterConfig that = (BooterConfig)o;
        if (!this.host.equals(that.host)) {
            return false;
        }
        if (this.port != that.port) {
            return false;
        }
        if (!this.password.equals(that.password)) {
            return false;
        }
        if (this.proxyHost == null && that.proxyHost != null || this.proxyHost != null && !this.proxyHost.equals(that.proxyHost)) {
            return false;
        }
        if (this.proxyPort != that.proxyPort) {
            return false;
        }
        if (this.protocol != that.protocol) {
            return false;
        }
        if (!this.username.equals(that.username)) {
            return false;
        }
        return this.getContext().equals(that.getContext());
    }

    public int hashCode() {
        int result = ((Serializable)Objects.firstNonNull((Object)((Object)this.protocol), (Object)"")).hashCode();
        result = 31 * result + ((String)Objects.firstNonNull((Object)this.host, (Object)"")).hashCode();
        result = 31 * result + this.port;
        if (this.proxyHost != null) {
            result = 31 * result + ((String)Objects.firstNonNull((Object)this.proxyHost, (Object)"")).hashCode();
        }
        result = 31 * result + this.proxyPort;
        result = 31 * result + ((String)Objects.firstNonNull((Object)this.username, (Object)"")).hashCode();
        result = 31 * result + ((String)Objects.firstNonNull((Object)this.password, (Object)"")).hashCode();
        result = 31 * result + this.getContext().hashCode();
        return result;
    }

    public static class Builder {
        private BooterConfig config;

        public Builder() {
            this.config = new BooterConfig();
        }

        public Builder(BooterConfig config) {
            this.config = config;
        }

        public Builder withProtocol(Protocol protocol) {
            this.config.protocol = protocol;
            return this;
        }

        public Builder withHost(String host) {
            this.config.host = host;
            return this;
        }

        public Builder withPort(int port) {
            this.config.port = port;
            return this;
        }

        public Builder withProxyHost(String proxyHost) {
            this.config.proxyHost = proxyHost;
            return this;
        }

        public Builder withProxyPort(int proxyPort) {
            this.config.proxyPort = proxyPort;
            return this;
        }

        public Builder withContext(String context) {
            this.config.context = context;
            return this;
        }

        public Builder withConnectionPoolSize(int poolSize) {
            this.config.connectionPoolSize = poolSize;
            return this;
        }

        public Builder withSocketTimeout(int socketTimeout) {
            this.config.socketTimeout = socketTimeout;
            return this;
        }

        public Builder withHttpRequestInterceptor(HttpRequestInterceptor interceptor) {
            this.config.httpRequestInterceptors.add(interceptor);
            return this;
        }

        public Builder withHttpRequestInterceptors(List<HttpRequestInterceptor> interceptors) {
            this.config.httpRequestInterceptors = interceptors;
            return this;
        }

        public Builder withCredentials(String username, String password) {
            this.config.username = username;
            this.config.password = password;
            return this;
        }

        public BooterConfig build() {
            return this.config;
        }
    }

    public static enum Protocol {
        HTTP("http"),
        HTTPS("https");

        private String protocol;

        private Protocol(String protocol) {
            this.protocol = protocol;
        }

        public String getProtocol() {
            return this.protocol;
        }
    }
}

