/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.core.MapBackedDataHolder;
import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.DefaultsAndMethodLookup;
import com.xebialabs.deployit.booter.remote.HttpClientHolder;
import com.xebialabs.deployit.booter.remote.client.ClientXStreamReaderWriter;
import com.xebialabs.deployit.booter.remote.invoker.DefaultsInvoker;
import com.xebialabs.deployit.booter.remote.invoker.InvocationHandlerInvoker;
import com.xebialabs.deployit.booter.remote.resteasy.DeployitClientException;
import com.xebialabs.deployit.booter.remote.service.StreamingImportingService;
import com.xebialabs.deployit.core.api.ConfigurationService;
import com.xebialabs.deployit.engine.api.ControlService;
import com.xebialabs.deployit.engine.api.DeploymentService;
import com.xebialabs.deployit.engine.api.InspectionService;
import com.xebialabs.deployit.engine.api.MetadataService;
import com.xebialabs.deployit.engine.api.PackageService;
import com.xebialabs.deployit.engine.api.PermissionService;
import com.xebialabs.deployit.engine.api.ReportService;
import com.xebialabs.deployit.engine.api.RepositoryService;
import com.xebialabs.deployit.engine.api.RoleService;
import com.xebialabs.deployit.engine.api.ServerService;
import com.xebialabs.deployit.engine.api.TaskBlockService;
import com.xebialabs.deployit.engine.api.TaskService;
import com.xebialabs.deployit.engine.api.UserService;
import com.xebialabs.deployit.engine.api.task.TaskBlockServiceDefaults;
import com.xebialabs.xltype.serialization.xml.StreamXmlReaderWriter;
import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ResponseProcessingException;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Proxies {
    private static final Logger logger = LoggerFactory.getLogger(Proxies.class);
    private final Map<Class<?>, Object> registeredProxies = new HashMap();
    private final Map<Class<?>, DefaultsAndMethodLookup> wrapperClassMap = new HashMap();
    private final HttpClientHolder httpClientHolder;
    private final BooterConfig booterConfig;
    private final ResteasyClient client;

    public Proxies(HttpClientHolder httpClientHolder, BooterConfig config) {
        this.httpClientHolder = httpClientHolder;
        this.booterConfig = config;
        XStreamReaderWriter xStreamReaderWriter = config.getXStreamReaderWriter() != null ? config.getXStreamReaderWriter() : new ClientXStreamReaderWriter(config);
        ResteasyClientBuilder resteasyClientBuilder = (ResteasyClientBuilder)ClientBuilder.newBuilder();
        this.client = (ResteasyClient)((ClientBuilder)((ClientBuilder)resteasyClientBuilder.httpEngine(httpClientHolder.createClientHttpEngine()).register((Object)xStreamReaderWriter)).register((Object)new StreamXmlReaderWriter())).build();
        this.init(config);
    }

    public static Logger getLogger() {
        return logger;
    }

    private static Iterable<Class<?>> allProxies() {
        ArrayList classes = new ArrayList();
        Collections.addAll(classes, ServerService.class, MetadataService.class, RepositoryService.class, ControlService.class, DeploymentService.class, InspectionService.class, PackageService.class, ConfigurationService.class, PermissionService.class, RoleService.class, TaskService.class, TaskBlockService.class, UserService.class);
        return classes;
    }

    public static Proxies reinitialize(Proxies oldProxies, HttpClientHolder httpClientHolder, BooterConfig config) {
        Proxies newProxies = new Proxies(httpClientHolder, config);
        if (oldProxies == null) {
            return newProxies;
        }
        for (Class<?> proxyClass : oldProxies.registeredProxies.keySet()) {
            if (newProxies.registeredProxies.containsKey(proxyClass)) continue;
            newProxies.doRegisterProxy(config.getUrl(), proxyClass, oldProxies.getWrapperClassMap().get(proxyClass));
        }
        return newProxies;
    }

    private void init(BooterConfig config) {
        for (Class<?> clazz : Proxies.allProxies()) {
            this.doRegisterProxy(config.getUrl(), clazz, this.getWrapperClassMap().get(clazz));
        }
    }

    private void doRegisterProxy(String url, Class<?> clazz, DefaultsAndMethodLookup defaultsAndMethodLookup) {
        if (defaultsAndMethodLookup == null) {
            this.registerProxy(url, clazz);
        } else {
            this.registerProxy(url, clazz, defaultsAndMethodLookup.getDefaultsClass(), defaultsAndMethodLookup.getLookup());
        }
    }

    public void registerProxy(String url, Class<?> clazz) {
        logger.debug("Registering Proxy: {}", clazz);
        this.registeredProxies.put(clazz, this.wrap(clazz, this.client.target(url).proxy(clazz)));
    }

    public void registerProxy(String url, Class<?> clazz, Class<?> wrapperClass, MethodHandles.Lookup lookup) {
        logger.debug("Registering Proxy: {} with additional methods of: {}", clazz, wrapperClass);
        this.wrapperClassMap.put(clazz, new DefaultsAndMethodLookup(wrapperClass, lookup));
        this.registeredProxies.put(clazz, this.wrap(wrapperClass, this.client.target(url).proxy(clazz), lookup));
    }

    private Object wrap(Class<?> clazz, Object proxy) {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(proxy);
        InvocationHandlerInvoker invocationHandlerInvoker = new InvocationHandlerInvoker(invocationHandler);
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)new CliExceptionHandler(invocationHandlerInvoker, this.booterConfig));
    }

    private Object wrap(Class<?> clazz, Object proxy, MethodHandles.Lookup lookup) {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(proxy);
        DefaultsInvoker defaultsInvoker = new DefaultsInvoker(invocationHandler, lookup);
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)new CliExceptionHandler(defaultsInvoker, this.booterConfig));
    }

    private Map<Class<?>, DefaultsAndMethodLookup> getWrapperClassMap() {
        this.wrapperClassMap.put(TaskBlockService.class, new DefaultsAndMethodLookup(TaskBlockServiceDefaults.class, TaskBlockServiceDefaults.getLookup()));
        return this.wrapperClassMap;
    }

    public <T> T getProxyInstance(Class<T> clazz) {
        return (T)this.registeredProxies.get(clazz);
    }

    public ServerService getServerService() {
        return this.getProxyInstance(ServerService.class);
    }

    public MetadataService getMetadataService() {
        return this.getProxyInstance(MetadataService.class);
    }

    public RepositoryService getRepositoryService() {
        return this.getProxyInstance(RepositoryService.class);
    }

    public ControlService getControlService() {
        return this.getProxyInstance(ControlService.class);
    }

    public DeploymentService getDeploymentService() {
        return this.getProxyInstance(DeploymentService.class);
    }

    public InspectionService getInspectionService() {
        return this.getProxyInstance(InspectionService.class);
    }

    public PackageService getPackageService() {
        return new StreamingImportingService(this.httpClientHolder, this.booterConfig, this);
    }

    public PermissionService getPermissionService() {
        return this.getProxyInstance(PermissionService.class);
    }

    public RoleService getRoleService() {
        return this.getProxyInstance(RoleService.class);
    }

    public TaskService getTaskService() {
        return this.getProxyInstance(TaskService.class);
    }

    public TaskBlockService getTaskBlockService() {
        return this.getProxyInstance(TaskBlockService.class);
    }

    public UserService getUserService() {
        return this.getProxyInstance(UserService.class);
    }

    public ReportService getReportService() {
        return this.getProxyInstance(ReportService.class);
    }

    private static class CliExceptionHandler
    implements InvocationHandler {
        private final InvocationHandler invocationHandler;
        private final BooterConfig booterConfig;

        public CliExceptionHandler(InvocationHandler invocationHandler, BooterConfig booterConfig) {
            this.invocationHandler = invocationHandler;
            this.booterConfig = booterConfig;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return this.invocationHandler.invoke(proxy, method, args);
            }
            catch (ResponseProcessingException rpe) {
                throw rpe.getCause();
            }
            catch (BadRequestException bre) {
                if (this.isXMLBody(bre)) {
                    return this.handleXMLBody(method, bre);
                }
                return this.handleTextBody(bre);
            }
        }

        private boolean isXMLBody(BadRequestException bre) {
            return ((List)bre.getResponse().getHeaders().get((Object)"Content-Type")).stream().anyMatch(o -> o.toString().contains("application/xml"));
        }

        private Object handleXMLBody(Method method, BadRequestException bre) {
            logger.debug("Caught a BadRequestException with an entity");
            InputStream inputStream = (InputStream)bre.getResponse().readEntity(InputStream.class);
            XStream xStream = XStreamReaderWriter.getConfiguredXStream();
            MapBackedDataHolder dataHolder = new MapBackedDataHolder();
            dataHolder.put((Object)"BOOTER_CONFIG", (Object)this.booterConfig.getKey());
            Object o = xStream.unmarshal(XStreamReaderWriter.HIERARCHICAL_STREAM_DRIVER.createReader(inputStream), null, (DataHolder)dataHolder);
            if (method.getReturnType().isInstance(o)) {
                return o;
            }
            throw new DeployitClientException(o, bre.getResponse().getStatus());
        }

        private Object handleTextBody(BadRequestException bre) {
            logger.debug("Caught a BadRequestException with a plain text body");
            InputStream inputStream = (InputStream)bre.getResponse().readEntity(InputStream.class);
            String response = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
            throw new DeployitClientException(response, bre.getResponse().getStatus());
        }
    }
}

