package com.xebialabs.platform.sugar

import scala.collection.convert.wrapAsScala._

trait ResourcesSugar {

  private def contextClassLoader: ClassLoader = Thread.currentThread().getContextClassLoader

  def resource(fileResource: String) = Option(contextClassLoader.getResource(fileResource)).getOrElse(notFound(fileResource))

  def resources(fileResource: String) = contextClassLoader.getResources(fileResource).toIterable

  def resourceAsInputStream(fileResource:String) = Option(contextClassLoader.getResourceAsStream(fileResource)).getOrElse(notFound(fileResource))

  private def notFound(classpathResource: String) = throw new IllegalArgumentException(s"Classpath resource $classpathResource not found")
}
