/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.planner;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.deployment.planner.StepAdapter;
import com.xebialabs.deployit.deployment.planner.StepPlan;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Checkpoint;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.transformer.PatchDictionary;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDeploymentPlanningContext
implements DeploymentPlanningContext {
    private static final Function<DeploymentStep, Step> adapt = input -> StepAdapter.wrapIfNeeded(input);
    private final HashMap<String, Object> attributes = Maps.newHashMap();
    private DeployedApplication deployedApplication;
    private DeployedApplication previousDeployedApplication;
    private Repository readOnlyRepository;
    private StepPlan plan;
    private boolean rollback;
    private static final Logger logger = LoggerFactory.getLogger(DefaultDeploymentPlanningContext.class);

    public DefaultDeploymentPlanningContext(DeployedApplication deployedApplication, DeployedApplication previousDeployedApplication, Repository readOnlyRepository, StepPlan plan, boolean rollback) {
        this.deployedApplication = deployedApplication;
        this.previousDeployedApplication = previousDeployedApplication;
        this.readOnlyRepository = readOnlyRepository;
        this.plan = plan;
        this.rollback = rollback;
    }

    public void addStep(DeploymentStep step2) {
        this.addStep((Step)adapt.apply((Object)step2));
    }

    public void addSteps(DeploymentStep ... steps) {
        this.addSteps(Iterables.transform((Iterable)Lists.newArrayList((Object[])steps), adapt));
    }

    public void addSteps(Collection<DeploymentStep> steps) {
        this.addSteps(Iterables.transform(steps, adapt));
    }

    public void addStep(Step step2) {
        logger.trace("Adding step [{} - {} ({})]", new Object[]{step2.getOrder(), step2.getDescription(), step2.getClass().getSimpleName()});
        this.plan.addStep(step2);
    }

    public void addSteps(Step ... steps) {
        logger.trace("Adding steps");
        for (Step step2 : steps) {
            logger.trace("[{} - {} ({})]", new Object[]{step2.getOrder(), step2.getDescription(), step2.getClass().getSimpleName()});
        }
        this.plan.addSteps(Lists.newArrayList((Object[])steps));
    }

    public void addSteps(Iterable<Step> steps) {
        logger.trace("Adding steps");
        for (Step step2 : steps) {
            logger.trace("[{} - {} ({})]", new Object[]{step2.getOrder(), step2.getDescription(), step2.getClass().getSimpleName()});
        }
        this.plan.addSteps(Lists.newArrayList(steps));
    }

    public void addCheckpoint(Step step2, Checkpoint checkpoint2) {
        Delta delta = checkpoint2.getDeltaToCheckpoint();
        Operation overrideOperation = checkpoint2.getOverrideOperation();
        if (overrideOperation != null) {
            if (delta.getOperation() != Operation.MODIFY) {
                Preconditions.checkArgument((delta.getOperation() == overrideOperation ? 1 : 0) != 0, (String)"The delta's operation (%s) and overrideOperation (%s) should match in non-modify scenarios", (Object)delta.getOperation(), (Object)overrideOperation);
            } else {
                Preconditions.checkArgument((overrideOperation != Operation.NOOP ? 1 : 0) != 0, (String)"Cannot set a NOOP override operation on a MODIFY delta (%s)", (Object)delta);
            }
        }
        this.plan.getCheckpoints().add(new StepPlan.Checkpoint(delta, step2, overrideOperation, checkpoint2.getIntermediateCheckpointName()));
    }

    public void addCheckpoint(Step step2, Delta delta) {
        this.addCheckpoint(step2, new Checkpoint(delta));
    }

    public void addCheckpoint(Step step2, Delta delta, Operation overrideOperation) {
        this.addCheckpoint(step2, new Checkpoint(delta, null, overrideOperation));
    }

    public void addCheckpoint(Step step2, Iterable<Delta> deltas) {
        for (Delta delta : deltas) {
            this.addCheckpoint(step2, new Checkpoint(delta));
        }
    }

    public void addStepWithCheckpoint(Step step2, Checkpoint checkpoint2) {
        this.addStep(step2);
        this.addCheckpoint(step2, checkpoint2);
    }

    public void addStepWithCheckpoint(Step step2, Delta delta) {
        this.addStepWithCheckpoint(step2, new Checkpoint(delta));
    }

    public void addStepWithCheckpoint(Step step2, Delta delta, Operation overrideOperation) {
        this.addStepWithCheckpoint(step2, new Checkpoint(delta, null, overrideOperation));
    }

    public void addStepWithCheckpoint(Step step2, Iterable<Delta> deltas) {
        this.addStep(step2);
        for (Delta delta : deltas) {
            this.addCheckpoint(step2, new Checkpoint(delta));
        }
    }

    public Object getAttribute(String param) {
        return this.attributes.get(param);
    }

    public void setAttribute(String param, Object value) {
        this.attributes.put(param, value);
        if (value instanceof ExecutionStateListener) {
            this.plan.getListeners().add((ExecutionStateListener)value);
        }
    }

    public DeployedApplication getDeployedApplication() {
        return this.deployedApplication;
    }

    public DeployedApplication getPreviousDeployedApplication() {
        return this.previousDeployedApplication;
    }

    public Repository getRepository() {
        return this.readOnlyRepository;
    }

    public String patch(String content, ConfigurationItem ci) {
        InputStream inputStream = this.patch(new ByteArrayInputStream(content.getBytes()), ci);
        try {
            return IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new RuntimeException("IO Error while processing patch", e);
        }
    }

    public InputStream patch(InputStream content, ConfigurationItem ci) {
        DeployedApplication currentDeployedApplication = this.getDeployedApplication() != null ? this.getDeployedApplication() : this.getPreviousDeployedApplication();
        List patchDictionaries = currentDeployedApplication.getEnvironment().getPatchDictionaries();
        logger.debug("Going to apply {} patch dictionaries for DeployedApplication [{}] on Environment [{}]", new Object[]{patchDictionaries.size(), currentDeployedApplication, currentDeployedApplication.getEnvironment()});
        InputStream intermediate = content;
        for (PatchDictionary patchDictionary : patchDictionaries) {
            logger.debug("Applying patch dictionary [{}] of type [{}] for ci [{}]", new Object[]{patchDictionary, patchDictionary.getType(), ci});
            intermediate = patchDictionary.apply(intermediate, ci);
        }
        return intermediate;
    }

    public boolean isRollback() {
        return this.rollback;
    }
}

