/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.planner;

import com.google.common.base.Strings;
import com.xebialabs.deployit.deployment.planner.ExecutablePlan;
import com.xebialabs.deployit.deployment.planner.Plan;
import com.xebialabs.deployit.deployment.planner.StepPlan;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.xlplatform.satellite.Satellite;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public abstract class CompositePlan
extends ExecutablePlan {
    private List<? extends ExecutablePlan> subPlans;

    protected CompositePlan(String description, List<? extends ExecutablePlan> subPlans, List<ExecutionStateListener> listeners) {
        super(description, listeners);
        this.subPlans = subPlans;
    }

    protected CompositePlan(String description, List<? extends ExecutablePlan> subPlans, List<ExecutionStateListener> listeners, Satellite satellite) {
        super(description, listeners, satellite);
        this.subPlans = subPlans;
    }

    public List<? extends ExecutablePlan> getSubPlans() {
        return this.subPlans;
    }

    @Override
    public List<StepPlan.Checkpoint> findCheckpoints() {
        ArrayList<StepPlan.Checkpoint> checkpoints = new ArrayList<StepPlan.Checkpoint>();
        for (Plan plan2 : this.getSubPlans()) {
            if (plan2 instanceof StepPlan) {
                checkpoints.addAll(((StepPlan)plan2).getCheckpoints());
                continue;
            }
            checkpoints.addAll(plan2.findCheckpoints());
        }
        return checkpoints;
    }

    protected static String indent(String str, int n) {
        StringBuilder sb = new StringBuilder();
        for (String s : str.split("\n")) {
            if (s.isEmpty()) continue;
            sb.append(String.format("%" + n + "s", "")).append("|").append(s).append("\n");
        }
        return sb.toString();
    }

    protected void writeBlockBoundery(PrintWriter out, int off) {
        out.println(Strings.repeat((String)"#", (int)(this.getDescription().length() + 12 + off)));
    }
}

