package com.xebialabs.deployit.deployment.planner

import com.xebialabs.deployit.deployment.planner.PlanSugar._
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification
import com.xebialabs.deployit.plugin.api.services.Repository

class RepositoryUpdateStepPlanner(wrappedPlanner: Planner) extends Planner with PlanSugar {

  import collection.convert.wrapAll._

  override def plan(spec: DeltaSpecification, repository: Repository): PhasedPlan = {
    val deploymentPlan = wrappedPlanner.plan(spec, repository)

    val deployedApplication = if (spec.getAppliedDistribution != null) spec.getAppliedDistribution else spec.getPreviousAppliedDistribution

    val repositoryStep = new StepPlan(s"Update Repository for ${deployedApplication.getName} ${spec.getOperation}", List(new RepositoryUpdateStep(spec = spec)), List())
    val repositoryPlan = new PlanPhase(repositoryStep, deploymentPlan.getDescription, List())

    deploymentPlan.copy(phases = deploymentPlan.phases :+ repositoryPlan)
  }

}