package com.xebialabs.deployit.deployment.planner;

import com.google.common.collect.ImmutableList;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Deployed;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import static java.lang.String.format;

@SuppressWarnings("serial")
public class DefaultDelta implements Delta, Serializable {

    private Operation operation;

    @SuppressWarnings("rawtypes")
    private Deployed previous;

    @SuppressWarnings("rawtypes")
    private Deployed deployed;

    private List<String> intermediateCheckpointNames = new ArrayList<String>();

    @SuppressWarnings("rawtypes")
    public DefaultDelta(Operation operation, Deployed previous, Deployed deployed) {
        super();
        this.operation = operation;
        this.previous = previous;
        this.deployed = deployed;
    }

    public DefaultDelta(Operation operation, Deployed previous, Deployed deployed, List<String> intermediateCheckpointNames) {
        super();
        this.operation = operation;
        this.previous = previous;
        this.deployed = deployed;
        this.intermediateCheckpointNames = ImmutableList.copyOf(intermediateCheckpointNames);
    }

    public Operation getOperation() {
        return operation;
    }

    @SuppressWarnings({"rawtypes", "unchecked"})
    @Override
    public Deployed getPrevious() {
        return (Deployed) previous;
    }

    @SuppressWarnings({"rawtypes", "unchecked"})
    public Deployed getDeployed() {
        return (Deployed) deployed;
    }

    @Override
    public List<String> getIntermediateCheckpoints() {
        return intermediateCheckpointNames;
    }

    @Override
    public String toString() {
        switch (operation) {
            case CREATE:
                return format("Delta[CREATE, %s]", deployed);
            case DESTROY:
                return format("Delta[DESTROY, %s]", previous);
            default:
                return format("Delta[%s, %s, %s]", operation, previous, deployed);
        }
    }
}
