package com.xebialabs.deployit.deployment.planner

import com.xebialabs.deployit.plugin.api.services.Repository

class PlannerAggregator(planner: Planner) extends MultiDeploymentPlanner {

  override def plan(multiSpec: MultiDeltaSpecification, repository: Repository): PhasedPlan = {
    import collection.convert.wrapAll._
    val plans = multiSpec.getDeltaSpecifications.toList.map(ds => planner.plan(ds, repository))
    val phases = plans.flatMap(p => p.phases)
    val listeners = plans.flatMap(p => p.getListeners)
    new PhasedPlan(phases, listeners)
  }
}
