package com.xebialabs.deployit.deployment.planner;

import static com.google.common.collect.Lists.newArrayList;

import java.util.List;

import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;

public class DeltaSpecificationBuilder {

    private Operation operation = Operation.CREATE;
    private List<Delta> deltas = newArrayList();
    private DeployedApplication previousDeployedApplication;
    private DeployedApplication deployedApplication;

    public static DeltaSpecificationBuilder newSpecification() {
        return new DeltaSpecificationBuilder();
    }

    @SuppressWarnings("rawtypes")
    public DeltaSpecificationBuilder create(Deployed d) {
        return with(Operation.CREATE, null, d);
    }

    @SuppressWarnings("rawtypes")
    public DeltaSpecificationBuilder modify(Deployed previous, Deployed d) {
        return with(Operation.MODIFY, previous, d);
    }

    @SuppressWarnings("rawtypes")
    public DeltaSpecificationBuilder destroy(Deployed d) {
        return with(Operation.DESTROY, d, null);
    }

    @SuppressWarnings("rawtypes")
    public DeltaSpecificationBuilder noOp(Deployed d) {
        return with(Operation.NOOP, d, d);
    }

    @SuppressWarnings("rawtypes")
    private DeltaSpecificationBuilder with(Operation operation, Deployed previous, Deployed deployed) {
        deltas.add(new DefaultDelta(operation, previous, deployed));
        return this;
    }

    public DeltaSpecificationBuilder with(Delta delta) {
        deltas.add(delta);
        return this;
    }

    public DeltaSpecificationBuilder upgrade(DeployedApplication previous, DeployedApplication deployment) {
        this.previousDeployedApplication = previous;
        this.deployedApplication = deployment;
        this.operation = Operation.MODIFY;
        return this;
    }

    public DeltaSpecificationBuilder undeploy(DeployedApplication deployment) {
	    this.previousDeployedApplication = deployment;
        this.deployedApplication = deployment;
        this.operation = Operation.DESTROY;
        return this;
    }

    public DeltaSpecificationBuilder initial(DeployedApplication deployment) {
        this.deployedApplication = deployment;
        this.operation = Operation.CREATE;
        return this;
    }

    public DeltaSpecification build() {
        return new DefaultDeltaSpecification(operation, previousDeployedApplication, deployedApplication, deltas);
    }
}
