package com.xebialabs.deployit.deployment.rules

import java.lang.Iterable
import java.util

import com.xebialabs.deployit.deployment.planner.{DefaultDeploymentPlanningContext, StepPlan}
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep
import com.xebialabs.deployit.plugin.api.deployment.planning.{Checkpoint, DeploymentPlanningContext}
import com.xebialabs.deployit.plugin.api.deployment.specification.{Delta, DeltaSpecification, Operation}
import com.xebialabs.deployit.plugin.api.flow.Step
import com.xebialabs.deployit.plugin.api.services.Repository
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication

object RulePlanningContext {
  def apply(spec: DeltaSpecification, stepRegistry: StepRegistry, readOnlyRepository: Repository, plan: StepPlan) = {
    val deployedApplication = spec.getOperation match {
      case Operation.DESTROY => null
      case _ => spec.getDeployedApplication
    }
    new RulePlanningContext(deployedApplication, spec.getPreviousDeployedApplication, readOnlyRepository, plan, spec.getOperation) {
      override def getStepRegistry: StepRegistry = stepRegistry
    }
  }
}

sealed abstract class RulePlanningContext(deployedApplication: DeployedApplication, previousDeployedApplication: DeployedApplication,
                                          readOnlyRepository: Repository, plan: StepPlan, operation: Operation, backwardsCompatible: Boolean, wrappedContext: DeploymentPlanningContext) extends ScalaJavaBridgeDeploymentPlanningContext {

  def this(deployedApplication: DeployedApplication, previousDeployedApplication: DeployedApplication, repo: Repository, plan: StepPlan, operation: Operation) =
    this(deployedApplication, previousDeployedApplication, repo, plan, operation, false, new DefaultDeploymentPlanningContext(deployedApplication, previousDeployedApplication, repo, plan))

  def getStepRegistry: StepRegistry

  def backwardCompatible: RulePlanningContext = {
    new RulePlanningContext(deployedApplication, previousDeployedApplication, readOnlyRepository, plan, operation, true, wrappedContext) {
      override def getStepRegistry: StepRegistry = RulePlanningContext.this.getStepRegistry
    }
  }

  override def getDeployedApplication: DeployedApplication = operation match {
    case Operation.DESTROY if backwardsCompatible => getPreviousDeployedApplication
    case _ => wrappedContext.getDeployedApplication
  }

  override def addStepWithCheckpoint(step: Step, checkpoint: Checkpoint): Unit = wrappedContext.addStepWithCheckpoint(step, checkpoint)

  override def addStepWithCheckpoint(step: Step, delta: Delta): Unit = wrappedContext.addStepWithCheckpoint(step, delta)

  override def addStepWithCheckpoint(step: Step, delta: Delta, overrideOperation: Operation): Unit = wrappedContext.addStepWithCheckpoint(step, delta, overrideOperation)

  override def addStepWithCheckpoint(step: Step, deltas: Iterable[Delta]): Unit = wrappedContext.addStepWithCheckpoint(step, deltas)

  override def getAttribute(name: String): AnyRef = wrappedContext.getAttribute(name)

  override def getPreviousDeployedApplication: DeployedApplication = wrappedContext.getPreviousDeployedApplication

  override def setAttribute(name: String, value: scala.Any): Unit = wrappedContext.setAttribute(name, value)

  override def addCheckpoint(step: Step, checkpoint: Checkpoint): Unit = wrappedContext.addCheckpoint(step, checkpoint)

  override def addCheckpoint(step: Step, delta: Delta): Unit = wrappedContext.addCheckpoint(step, delta)

  override def addCheckpoint(step: Step, delta: Delta, overrideOperation: Operation): Unit = wrappedContext.addCheckpoint(step, delta, overrideOperation)

  override def addCheckpoint(step: Step, deltas: Iterable[Delta]): Unit = wrappedContext.addCheckpoint(step, deltas)

  override def addSteps(steps: util.Collection[DeploymentStep]): Unit = wrappedContext.addSteps(steps)

  override def addSteps(steps: Iterable[Step]): Unit = wrappedContext.addSteps(steps)

  override def getRepository: Repository = wrappedContext.getRepository

  override def addStep(step: DeploymentStep): Unit = wrappedContext.addStep(step)

  override def addStep(step: Step): Unit = wrappedContext.addStep(step)
}