package com.xebialabs.deployit.deployment.rules

import java.lang.reflect.{InvocationTargetException, Method, Modifier}

import com.xebialabs.deployit.booter.local.utils.ReflectionUtils._
import com.xebialabs.deployit.plugin.api.Deprecations._
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas
import com.xebialabs.deployit.plugin.api.rules.Scope

object JavaContributorInvokerRule {
  def buildName(contributor: Method) = s"${contributor.getDeclaringClass.getName}.${contributor.getName}"
}

import com.xebialabs.deployit.deployment.rules.JavaContributorInvokerRule._

class JavaContributorInvokerRule(contributor: Method) extends Rule(buildName(contributor), Scope.PLAN) {

  override def canFire(deltas: AnyRef, context: RulePlanningContext): Boolean = deltas.isInstanceOf[Deltas]

  override def doFire(deltas: AnyRef, context: RulePlanningContext) {
    try {
      val compatibleContext = context.backwardCompatible
      if (Modifier.isStatic(contributor.getModifiers)) {
        contributor.invoke(null, deltas, compatibleContext)
      } else {
        deprecated("Non-static contributors are considered deprecated, consider making [%s] static", contributor)
        val contributorInstance: Any = contributor.getDeclaringClass.newInstance
        contributor.invoke(contributorInstance, deltas, compatibleContext)
      }
    } catch {
      case e: InvocationTargetException => throw handleInvocationTargetException(e, "")
      case e: Exception => throw e
    }
  }
}
