package com.xebialabs.deployit.deployment.planner

import com.xebialabs.deployit.deployment.planner.StepPlan.StepWithPlanningInfo
import com.xebialabs.deployit.engine.api.execution.StepState
import com.xebialabs.deployit.engine.tasker.BlockBuilders._
import com.xebialabs.deployit.engine.tasker.Phase.PhaseBuilder
import com.xebialabs.deployit.engine.tasker.{ExecutableBlockBuilder, PhaseContainerBuilder, TaskStep}
import com.xebialabs.deployit.plugin.api.flow.PreviewStep

import scala.collection.convert.wrapAll._
import scala.collection.mutable

object Plans {
  def toBlockBuilder(plan: PhasedPlan): PhaseContainerBuilder = {
    val phaseBuilders: mutable.Buffer[PhaseBuilder] = plan.phases.map(toPhaseBuilder)
    phases(plan.getDescription, phaseBuilders:_*)
  }

  def toPhaseBuilder(planPhase: PlanPhase): PhaseBuilder = {
    val executableBlockBuilder = toExecutableBlockBuilder(planPhase.plan)
    val phaseBuilder: PhaseBuilder = phase(planPhase.getDescription, planPhase.getDescription, executableBlockBuilder)
    planPhase.alwaysExecuted match {
      case true => phaseBuilder.asAlwaysExecuted
      case false => phaseBuilder
    }
  }

  def toExecutableBlockBuilder(plan: ExecutablePlan): ExecutableBlockBuilder = plan match {
    case sp: SerialPlan => serial(sp.getDescription, sp.satellite, sp.getSubPlans.map(toExecutableBlockBuilder))
    case pp: ParallelPlan => parallel(pp.getDescription, pp.satellite, pp.getSubPlans.map(toExecutableBlockBuilder))
    case stp: StepPlan => steps(stp.getDescription, Option(stp.satellite), asTaskSteps(stp))
  }

  private def asTaskSteps(plan: StepPlan): List[StepState] = {
    plan.getStepsWithPlanningInfo.map { swpi: StepWithPlanningInfo =>
      val taskStep: TaskStep = new TaskStep(swpi.getStep)
      var i: Int = 0
      taskStep.getMetadata.put("order", Integer.toString(swpi.getStep.getOrder))
      taskStep.getMetadata.put("previewAvailable", swpi.getStep.isInstanceOf[PreviewStep].toString)
      taskStep.getMetadata.put("rule", swpi.getRule)
      import scala.collection.JavaConversions._
      swpi.getDeltas.zipWithIndex.foreach { case (d, i) =>
        taskStep.getMetadata.put(s"deployed_$i", Option(d.getDeployed).getOrElse(d.getPrevious).getId)
      }
      taskStep
    }.toList
  }
}
