package com.xebialabs.deployit.deployment.planner

import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification
import com.xebialabs.deployit.plugin.api.services.Repository

import collection.convert.wrapAll._

class SimplifyingDeploymentPlanner(wrappedPlanner: Planner) extends Planner {

  def simplify(plan: Plan): Plan = plan match {
    case cp: CompositePlan if cp.getSubPlans.size() == 1 => simplify(cp.getSubPlans.get(0))
    case pp: ParallelPlan => simplifyComposite(pp, (cp, l) => new ParallelPlan(cp.getDescription, l, cp.getListeners)).getOrElse(List(new StepPlan(pp.getDescription, pp.getListeners))).get(0)
    case sp: SerialPlan => simplifyComposite(sp, (cp, l) => new SerialPlan(cp.getDescription, l, cp.getListeners)).getOrElse(List(new StepPlan(sp.getDescription, sp.getListeners))).get(0)
    case p@_ => p
  }

  def simplifySubplans(cp: CompositePlan, parentPlan: Class[_ <: CompositePlan]) = cp.getSubPlans.collect({
    case p: Plan => simplify(p, parentPlan)
  }).flatten.flatten.toList

  def simplify(plan: Plan, parentPlan: Class[_ <: CompositePlan]): Option[List[Plan]] = plan match {
    case cp: CompositePlan if cp.getSubPlans.isEmpty => None
    case cp: CompositePlan if cp.getSubPlans.size() == 1 => simplify(cp.getSubPlans.get(0), parentPlan)
    case cp: CompositePlan if cp.getClass == parentPlan =>
      simplifySubplans(cp, parentPlan) match {
        case Nil => None
        case x@_ => Some(x)
      }
    case pp: ParallelPlan => simplifyComposite(pp, (cp, l) => new ParallelPlan(cp.getDescription, l, cp.getListeners))
    case sp: SerialPlan => simplifyComposite(sp, (cp, l) => new SerialPlan(cp.getDescription, l, cp.getListeners))
    case p: StepPlan if !p.getSteps.isEmpty => Some(List(p))
    case p: StepPlan => None
  }

  def simplifyComposite(cp: CompositePlan, f: (CompositePlan, List[Plan]) => CompositePlan): Option[List[Plan]] = simplifySubplans(cp, cp.getClass) match {
    case Nil => None
    case head :: Nil => Some(List(head))
    case x@_ => Some(List(f(cp, x)))
  }

  def plan(spec: DeltaSpecification, repository: Repository): Plan = {
    val complexPlan: Plan = wrappedPlanner.plan(spec, repository)
    if (spec.getDeployedApplication.isOptimizePlan) {
      simplify(complexPlan)
    } else {
      complexPlan
    }
  }
}
