/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.planner;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.deployment.planner.Plan;
import com.xebialabs.deployit.deployment.planner.StepPlan;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class CompositePlan
extends Plan {
    private List<? extends Plan> subPlans;

    protected CompositePlan(String description, List<? extends Plan> subPlans, List<ExecutionStateListener> listeners) {
        super(description, listeners);
        this.subPlans = subPlans;
    }

    public List<? extends Plan> getSubPlans() {
        return this.subPlans;
    }

    @Override
    public Set<StepPlan.Checkpoint> findCheckpoints() {
        HashSet checkpoints = Sets.newHashSet();
        for (Plan plan : this.getSubPlans()) {
            if (plan instanceof StepPlan) {
                checkpoints.addAll(((StepPlan)plan).getCheckpoints());
                continue;
            }
            checkpoints.addAll(plan.findCheckpoints());
        }
        return checkpoints;
    }

    protected static String indent(String str, int n) {
        StringBuilder sb = new StringBuilder();
        for (String s : str.split("\n")) {
            if (s.isEmpty()) continue;
            sb.append(String.format("%" + n + "s", "")).append("|").append(s).append("\n");
        }
        return sb.toString();
    }

    protected void writeBlockBoundery(PrintWriter out, int off) {
        out.println(Strings.repeat((String)"#", (int)(this.getDescription().length() + 12 + off)));
    }
}

