package com.xebialabs.deployit.deployment.orchestrator;

import java.util.Map;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;

import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Version;

public class DescriptionHelper {

    private static Map verbs = ImmutableMap.of(
            Operation.CREATE, "Deploying",
            Operation.DESTROY, "Undeploying",
            Operation.MODIFY, "Updating",
            Operation.NOOP, "Not updating");

    private static Joiner joinWithSpaces = Joiner.on(" ");

    public static String getDescriptionForSpec(DeltaSpecification specification){
        DeployedApplication deployedApplication = specification.getDeployedApplication();
        return joinWithSpaces.join(
                verbs.get(specification.getOperation()),
                deployedApplication.getName(),
                deployedApplication.getVersion().getName(),
                "on environment",
                deployedApplication.getEnvironment().getName());
    }

    public static String getDescriptionForContainer(Operation op, Container con){
        return joinWithSpaces.join(
                verbs.get(op),
                "on container",
                con.getName());
    }

    public static String getDescriptionForPackage(Operation op, Version version){
        return joinWithSpaces.join(
                verbs.get(op),
                "package",
                version.getApplication().getName(),
                version.getName());
    }
}
