/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.rules;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.deployment.rules.Rule;
import com.xebialabs.deployit.deployment.rules.RuleStore;
import com.xebialabs.deployit.deployment.rules.Scope;
import com.xebialabs.deployit.deployment.rules.ScriptRule;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaderXSDFactory;

public class XmlRulesParser {
    public static final Namespace RULES_NAMESPACE = Namespace.getNamespace((String)"http://www.xebialabs.com/deployit/rules");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseRules(URL rulesFile, RuleStore store) {
        SAXBuilder b;
        try {
            XMLReaderXSDFactory xmlReaderXSDFactory = new XMLReaderXSDFactory(new URL[]{Thread.currentThread().getContextClassLoader().getResource("rules.xsd")});
            b = new SAXBuilder((XMLReaderJDOMFactory)xmlReaderXSDFactory);
        }
        catch (JDOMException e) {
            throw new IllegalStateException("Could not find the 'rules.xsd' XSD file", e);
        }
        InputStream in = null;
        try {
            in = rulesFile.openStream();
            Document document = b.build(in);
            Element rootElement = document.getRootElement();
            ArrayList rulesElements = Lists.newArrayList();
            ArrayList disableRulesElements = Lists.newArrayList();
            this.collectElements(rootElement, rulesElements, disableRulesElements);
            this.parseElements(rulesElements, disableRulesElements, store);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        finally {
            Closeables.closeQuietly((Closeable)in);
        }
    }

    private void collectElements(Element rootElement, List<Element> rulesElements, List<Element> disableRulesElements) {
        for (Element element : rootElement.getChildren()) {
            if (element.getName().equals("rule")) {
                rulesElements.add(element);
                continue;
            }
            if (!element.getName().equals("disable-rule")) continue;
            disableRulesElements.add(element);
        }
    }

    private void parseElements(List<Element> rulesElements, List<Element> disableRulesElements, RuleStore store) {
        for (Element rulesElement : rulesElements) {
            this.parseRule(rulesElement, store);
        }
        for (Element disableRulesElement : disableRulesElements) {
            this.parseRuleDisable(disableRulesElement, store);
        }
    }

    private void parseRule(Element ruleElement, RuleStore store) {
        String name = ruleElement.getAttributeValue("name");
        String scopeName = ruleElement.getAttributeValue("scope");
        Scope scope = Scope.getScope(scopeName);
        ScriptRule scriptRule = new ScriptRule(name, scope);
        if (ruleElement.getChild("script", RULES_NAMESPACE) != null) {
            scriptRule.setScript(ruleElement.getChildText("script", RULES_NAMESPACE));
        }
        store.registerRule(scriptRule);
    }

    private void parseRuleDisable(Element element, RuleStore store) {
        String name = element.getAttributeValue("name");
        Rule rule = store.getRule(name);
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Rule [%s] has not been defined, and cannot be disabled", name));
        }
        rule.disable();
    }
}

